/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig;

import brave.CurrentSpanCustomizer;
import brave.ErrorParser;
import brave.Tracer;
import brave.Tracing;
import brave.context.log4j2.ThreadContextCurrentTraceContext;
import brave.propagation.B3Propagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.Propagation;
import brave.sampler.Sampler;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.DefaultSpanNamer;
import org.springframework.cloud.sleuth.SpanAdjuster;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SleuthProperties.class})
public class TraceAutoConfiguration {
    public static final String TRACER_BEAN_NAME = "tracer";
    @Autowired(required=false)
    List<SpanAdjuster> spanAdjusters = new ArrayList<SpanAdjuster>();

    @Bean
    @ConditionalOnMissingBean
    Tracing tracing(@Value(value="${spring.zipkin.service.name:${spring.application.name:default}}") String serviceName, Propagation.Factory factory, CurrentTraceContext currentTraceContext, Reporter<Span> reporter, Sampler sampler, ErrorParser errorParser, SleuthProperties sleuthProperties) {
        return Tracing.newBuilder().sampler(sampler).errorParser(errorParser).localServiceName(serviceName).propagationFactory(factory).currentTraceContext(currentTraceContext).spanReporter(this.adjustedReporter(reporter)).traceId128Bit(sleuthProperties.isTraceId128()).supportsJoin(sleuthProperties.isSupportsJoin()).build();
    }

    private Reporter<Span> adjustedReporter(Reporter<Span> delegate) {
        return span -> {
            Span spanToAdjust = span;
            for (SpanAdjuster spanAdjuster : this.spanAdjusters) {
                spanToAdjust = spanAdjuster.adjust(spanToAdjust);
            }
            delegate.report((Object)spanToAdjust);
        };
    }

    @Bean(name={"tracer"})
    @ConditionalOnMissingBean
    Tracer tracer(Tracing tracing) {
        return tracing.tracer();
    }

    @Bean
    @ConditionalOnMissingBean
    Sampler sleuthTraceSampler() {
        return Sampler.NEVER_SAMPLE;
    }

    @Bean
    @ConditionalOnMissingBean
    SpanNamer sleuthSpanNamer() {
        return new DefaultSpanNamer();
    }

    @Bean
    @ConditionalOnMissingBean
    Propagation.Factory sleuthPropagation(SleuthProperties sleuthProperties) {
        if (sleuthProperties.getBaggageKeys().isEmpty() && sleuthProperties.getPropagationKeys().isEmpty()) {
            return B3Propagation.FACTORY;
        }
        ExtraFieldPropagation.FactoryBuilder factoryBuilder = ExtraFieldPropagation.newFactoryBuilder((Propagation.Factory)B3Propagation.FACTORY);
        if (!sleuthProperties.getBaggageKeys().isEmpty()) {
            factoryBuilder = factoryBuilder.addPrefixedFields("baggage-", sleuthProperties.getBaggageKeys()).addPrefixedFields("baggage_", sleuthProperties.getBaggageKeys());
        }
        if (!sleuthProperties.getPropagationKeys().isEmpty()) {
            for (String key : sleuthProperties.getPropagationKeys()) {
                factoryBuilder = factoryBuilder.addField(key);
            }
        }
        return factoryBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    CurrentTraceContext sleuthCurrentTraceContext() {
        return ThreadContextCurrentTraceContext.create();
    }

    @Bean
    @ConditionalOnMissingBean
    Reporter<Span> noOpSpanReporter() {
        return Reporter.NOOP;
    }

    @Bean
    @ConditionalOnMissingBean
    ErrorParser errorParser() {
        return new ErrorParser();
    }

    @Bean
    @ConditionalOnMissingBean
    CurrentSpanCustomizer spanCustomizer(Tracing tracing) {
        return CurrentSpanCustomizer.create((Tracing)tracing);
    }
}

