/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.annotation;

import brave.SpanCustomizer;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.annotation.NewSpan;
import org.springframework.cloud.sleuth.annotation.NewSpanParser;
import org.springframework.cloud.sleuth.util.SpanNameUtil;
import org.springframework.util.StringUtils;

class DefaultNewSpanParser
implements NewSpanParser {
    private static final Log log = LogFactory.getLog(DefaultNewSpanParser.class);

    DefaultNewSpanParser() {
    }

    @Override
    public void parse(MethodInvocation pjp, NewSpan newSpan, SpanCustomizer span) {
        String name = StringUtils.isEmpty((Object)newSpan.name()) ? pjp.getMethod().getName() : newSpan.name();
        String changedName = SpanNameUtil.toLowerHyphen(name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("For the class [" + pjp.getThis().getClass() + "] method [" + pjp.getMethod().getName() + "] will name the span [" + changedName + "]"));
        }
        span.name(changedName);
    }
}

