/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoRestTemplateCustomizer;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanInjector;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.client.SleuthWebClientEnabled;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRestTemplateBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRestTemplateCustomizer;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRestTemplateInterceptor;
import org.springframework.cloud.sleuth.instrument.web.client.TraceUserInfoRestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.web.client.RestTemplate;

@Configuration
@SleuthWebClientEnabled
@ConditionalOnClass(value={RestTemplate.class})
@ConditionalOnBean(value={HttpTraceKeysInjector.class})
@AutoConfigureAfter(value={TraceWebAutoConfiguration.class})
public class TraceWebClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TraceRestTemplateInterceptor traceRestTemplateInterceptor(Tracer tracer, HttpSpanInjector spanInjector, HttpTraceKeysInjector httpTraceKeysInjector, ErrorParser errorParser) {
        return new TraceRestTemplateInterceptor(tracer, spanInjector, httpTraceKeysInjector, errorParser);
    }

    @Configuration
    @ConditionalOnClass(value={UserInfoRestTemplateCustomizer.class, OAuth2RestTemplate.class})
    protected static class TraceOAuthConfiguration {
        protected TraceOAuthConfiguration() {
        }

        @Bean
        static UserInfoRestTemplateCustomizerBeanPostProcessor userInfoRestTemplateCustomizerBeanPostProcessor(BeanFactory beanFactory) {
            return new UserInfoRestTemplateCustomizerBeanPostProcessor(beanFactory);
        }

        @Bean
        @ConditionalOnMissingBean
        UserInfoRestTemplateCustomizer traceUserInfoRestTemplateCustomizer(BeanFactory beanFactory) {
            return new TraceUserInfoRestTemplateCustomizer(beanFactory);
        }

        private static class UserInfoRestTemplateCustomizerBeanPostProcessor
        implements BeanPostProcessor {
            private final BeanFactory beanFactory;

            UserInfoRestTemplateCustomizerBeanPostProcessor(BeanFactory beanFactory) {
                this.beanFactory = beanFactory;
            }

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                BeanFactory beanFactory = this.beanFactory;
                if (bean instanceof UserInfoRestTemplateCustomizer && !(bean instanceof TraceUserInfoRestTemplateCustomizer)) {
                    return new TraceUserInfoRestTemplateCustomizer(beanFactory, bean);
                }
                return bean;
            }
        }
    }

    @Configuration
    protected static class TraceInterceptorConfiguration {
        @Autowired
        private TraceRestTemplateInterceptor traceRestTemplateInterceptor;

        protected TraceInterceptorConfiguration() {
        }

        @Bean
        @Order
        RestTemplateCustomizer traceRestTemplateCustomizer() {
            return new TraceRestTemplateCustomizer(this.traceRestTemplateInterceptor);
        }

        @Bean
        static TraceRestTemplateBeanPostProcessor traceRestTemplateBPP(BeanFactory beanFactory) {
            return new TraceRestTemplateBeanPostProcessor(beanFactory);
        }
    }
}

