/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.instrument.web.SsLogSetter;

class TraceServletOutputStream
extends ServletOutputStream {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final ServletOutputStream delegate;
    private final Span span;

    TraceServletOutputStream(ServletOutputStream delegate, Span span) {
        this.delegate = delegate;
        this.span = span;
    }

    public boolean isReady() {
        return this.delegate.isReady();
    }

    public void setWriteListener(WriteListener listener) {
        this.delegate.setWriteListener(listener);
    }

    public void write(int b) throws IOException {
        this.delegate.write(b);
    }

    public void print(String s) throws IOException {
        this.delegate.print(s);
    }

    public void print(boolean b) throws IOException {
        this.delegate.print(b);
    }

    public void print(char c) throws IOException {
        this.delegate.print(c);
    }

    public void print(int i) throws IOException {
        this.delegate.print(i);
    }

    public void print(long l) throws IOException {
        this.delegate.print(l);
    }

    public void print(float f) throws IOException {
        this.delegate.print(f);
    }

    public void print(double d) throws IOException {
        this.delegate.print(d);
    }

    public void println() throws IOException {
        this.delegate.println();
    }

    public void println(String s) throws IOException {
        this.delegate.println(s);
    }

    public void println(boolean b) throws IOException {
        this.delegate.println(b);
    }

    public void println(char c) throws IOException {
        this.delegate.println(c);
    }

    public void println(int i) throws IOException {
        this.delegate.println(i);
    }

    public void println(long l) throws IOException {
        this.delegate.println(l);
    }

    public void println(float f) throws IOException {
        this.delegate.println(f);
    }

    public void println(double d) throws IOException {
        this.delegate.println(d);
    }

    public void write(byte[] b) throws IOException {
        this.delegate.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
    }

    public void flush() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Will annotate SS once the stream is flushed");
        }
        SsLogSetter.annotateWithServerSendIfLogIsNotAlreadyPresent(this.span);
        this.delegate.flush();
    }

    public void close() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Will annotate SS once the stream is closed");
        }
        SsLogSetter.annotateWithServerSendIfLogIsNotAlreadyPresent(this.span);
        this.delegate.close();
    }
}

