/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.Map;
import java.util.Random;
import org.springframework.cloud.sleuth.B3Utils;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapExtractor;
import org.springframework.cloud.sleuth.util.TextMapUtil;

public class HeaderBasedMessagingExtractor
implements MessagingSpanTextMapExtractor {
    private final Random random = new Random();

    @Override
    public Span joinTrace(SpanTextMap textMap) {
        boolean traceIdMissing;
        Map<String, String> carrier = TextMapUtil.asMap(textMap);
        boolean spanIdMissing = !this.hasSpanId(carrier);
        boolean bl = traceIdMissing = !this.hasTraceId(carrier);
        if ("1".equals(carrier.get("spanFlags"))) {
            String traceId = this.generateTraceIdIfMissing(carrier, traceIdMissing);
            if (spanIdMissing) {
                carrier.put("spanId", traceId);
            }
        } else if (spanIdMissing) {
            return null;
        }
        boolean idMissing = spanIdMissing || traceIdMissing;
        return this.extractSpanFromHeaders(carrier, Span.builder(), idMissing);
    }

    private boolean hasTraceId(Map<String, String> carrier) {
        return this.hasHeader(carrier, "b3") || this.hasHeader(carrier, "spanTraceId");
    }

    private boolean hasSpanId(Map<String, String> carrier) {
        return this.hasHeader(carrier, "b3") || this.hasHeader(carrier, "spanId");
    }

    private String generateTraceIdIfMissing(Map<String, String> carrier, boolean traceIdMissing) {
        if (traceIdMissing) {
            long id = this.random.nextLong();
            carrier.put("spanTraceId", Span.idToHex(id));
        }
        return this.traceId(carrier);
    }

    private Span extractSpanFromHeaders(Map<String, String> carrier, Span.SpanBuilder spanBuilder, boolean idMissing) {
        boolean spanSampled;
        String traceId = this.traceId(carrier);
        spanBuilder = spanBuilder.traceIdHigh(traceId.length() == 32 ? Span.hexToId(traceId, 0) : 0L).traceId(Span.hexToId(traceId)).spanId(Span.hexToId(this.spanId(carrier)));
        B3Utils.Sampled sampled = this.sampled(carrier);
        boolean debug = sampled == B3Utils.Sampled.DEBUG;
        boolean bl = spanSampled = sampled == B3Utils.Sampled.SAMPLED;
        if (debug) {
            spanBuilder.exportable(true);
        } else {
            spanBuilder.exportable(spanSampled);
        }
        String processId = carrier.get("spanProcessId");
        String spanName = carrier.get("spanName");
        if (spanName != null) {
            spanBuilder.name(spanName);
        }
        if (processId != null) {
            spanBuilder.processId(processId);
        }
        this.setParentIdIfApplicable(carrier, spanBuilder, "spanParentSpanId");
        spanBuilder.remote(true);
        spanBuilder.shared((debug || spanSampled) && !idMissing);
        for (Map.Entry<String, String> entry : carrier.entrySet()) {
            if (!entry.getKey().toLowerCase().startsWith("baggage_")) continue;
            spanBuilder.baggage(this.unprefixedKey(entry.getKey()), entry.getValue());
        }
        return spanBuilder.build();
    }

    private String traceId(Map<String, String> carrier) {
        return B3Utils.traceId("b3", "spanTraceId", carrier);
    }

    private String spanId(Map<String, String> carrier) {
        return B3Utils.spanId("b3", "spanId", carrier);
    }

    private B3Utils.Sampled sampled(Map<String, String> carrier) {
        return B3Utils.sampled("b3", "spanSampled", "spanFlags", carrier);
    }

    boolean hasHeader(Map<String, String> message, String name) {
        return message.containsKey(name);
    }

    private void setParentIdIfApplicable(Map<String, String> carrier, Span.SpanBuilder spanBuilder, String spanParentIdHeader) {
        String parentId = B3Utils.parentSpanId("b3", spanParentIdHeader, carrier);
        if (parentId != null) {
            spanBuilder.parent(Span.hexToId(parentId));
        }
    }

    private String unprefixedKey(String key) {
        return key.substring(key.indexOf("_") + 1).toLowerCase();
    }
}

