/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.TraceRunnable;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.LocalComponentTraceRunnable;

public class SpanContinuingTraceRunnable
extends TraceRunnable {
    private final LocalComponentTraceRunnable traceRunnable;

    public SpanContinuingTraceRunnable(Tracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, Runnable delegate) {
        super(tracer, spanNamer, delegate);
        this.traceRunnable = new LocalComponentTraceRunnable(tracer, traceKeys, spanNamer, delegate);
    }

    public SpanContinuingTraceRunnable(Tracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, Runnable delegate, String name) {
        super(tracer, spanNamer, delegate, name);
        this.traceRunnable = new LocalComponentTraceRunnable(tracer, traceKeys, spanNamer, delegate, name);
    }

    @Override
    public void run() {
        Span span = this.startSpan();
        try {
            this.getDelegate().run();
        }
        finally {
            this.close(span);
        }
    }

    @Override
    protected Span startSpan() {
        Span span = this.getParent();
        if (span == null) {
            return this.traceRunnable.startSpan();
        }
        return this.continueSpan(span);
    }

    @Override
    protected void close(Span span) {
        if (this.getParent() == null) {
            super.close(span);
        } else {
            super.detachSpan(span);
        }
    }
}

