/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.concurrent.Callable;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.TraceCallable;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.LocalComponentTraceCallable;

public class SpanContinuingTraceCallable<V>
extends TraceCallable<V> {
    private final LocalComponentTraceCallable<V> traceCallable;

    public SpanContinuingTraceCallable(Tracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, Callable<V> delegate) {
        super(tracer, spanNamer, delegate);
        this.traceCallable = new LocalComponentTraceCallable<V>(tracer, traceKeys, spanNamer, delegate);
    }

    public SpanContinuingTraceCallable(Tracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, String name, Callable<V> delegate) {
        super(tracer, spanNamer, delegate, name);
        this.traceCallable = new LocalComponentTraceCallable<V>(tracer, traceKeys, spanNamer, name, delegate);
    }

    @Override
    public V call() throws Exception {
        Span span = this.startSpan();
        try {
            Object v = this.getDelegate().call();
            return v;
        }
        finally {
            this.close(span);
        }
    }

    @Override
    protected Span startSpan() {
        Span span = this.getParent();
        if (span == null) {
            return this.traceCallable.startSpan();
        }
        return this.continueSpan(span);
    }

    @Override
    protected void close(Span span) {
        if (this.getParent() == null) {
            super.close(span);
        } else {
            super.detachSpan(span);
        }
    }
}

