/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceExecutor;
import org.springframework.util.ReflectionUtils;

class ExecutorMethodInterceptor<T extends Executor>
implements MethodInterceptor {
    private final T delegate;
    private final BeanFactory beanFactory;

    ExecutorMethodInterceptor(T delegate, BeanFactory beanFactory) {
        this.delegate = delegate;
        this.beanFactory = beanFactory;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Executor executor = this.executor(this.beanFactory, this.delegate);
        Method methodOnTracedBean = this.getMethod(invocation, executor);
        if (methodOnTracedBean != null) {
            return methodOnTracedBean.invoke((Object)executor, invocation.getArguments());
        }
        return invocation.proceed();
    }

    private Method getMethod(MethodInvocation invocation, Object object) {
        Method method = invocation.getMethod();
        return ReflectionUtils.findMethod(object.getClass(), (String)method.getName(), (Class[])method.getParameterTypes());
    }

    Executor executor(BeanFactory beanFactory, T executor) {
        return new LazyTraceExecutor(beanFactory, (Executor)executor);
    }
}

