/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.annotation;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.annotation.DefaultSpanCreator;
import org.springframework.cloud.sleuth.annotation.NoOpTagValueResolver;
import org.springframework.cloud.sleuth.annotation.SleuthAdvisorConfig;
import org.springframework.cloud.sleuth.annotation.SleuthAnnotationProperties;
import org.springframework.cloud.sleuth.annotation.SpanCreator;
import org.springframework.cloud.sleuth.annotation.SpelTagValueExpressionResolver;
import org.springframework.cloud.sleuth.annotation.TagValueExpressionResolver;
import org.springframework.cloud.sleuth.annotation.TagValueResolver;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;

@Configuration
@Role(value=2)
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnProperty(name={"spring.sleuth.annotation.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
@EnableConfigurationProperties(value={SleuthAnnotationProperties.class})
public class SleuthAnnotationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    SpanCreator spanCreator(Tracer tracer) {
        return new DefaultSpanCreator(tracer);
    }

    @Bean
    @ConditionalOnMissingBean
    TagValueExpressionResolver spelTagValueExpressionResolver() {
        return new SpelTagValueExpressionResolver();
    }

    @Bean
    @ConditionalOnMissingBean
    TagValueResolver noOpTagValueResolver() {
        return new NoOpTagValueResolver();
    }

    @Bean
    @Role(value=2)
    SleuthAdvisorConfig sleuthAdvisorConfig() {
        return new SleuthAdvisorConfig();
    }
}

