/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.util.ArrayList;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRestTemplateInterceptor;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

class RestTemplateInterceptorInjector {
    private final TraceRestTemplateInterceptor interceptor;

    RestTemplateInterceptorInjector(TraceRestTemplateInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    void inject(RestTemplate restTemplate) {
        if (this.hasTraceInterceptor(restTemplate)) {
            return;
        }
        ArrayList<TraceRestTemplateInterceptor> interceptors = new ArrayList<TraceRestTemplateInterceptor>(restTemplate.getInterceptors());
        interceptors.add(0, this.interceptor);
        restTemplate.setInterceptors(interceptors);
    }

    private boolean hasTraceInterceptor(RestTemplate restTemplate) {
        for (ClientHttpRequestInterceptor interceptor : restTemplate.getInterceptors()) {
            if (!(interceptor instanceof TraceRestTemplateInterceptor)) continue;
            return true;
        }
        return false;
    }
}

