/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.scheduling;

import java.util.regex.Pattern;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.scheduling.SleuthSchedulingProperties;
import org.springframework.cloud.sleuth.instrument.scheduling.TraceSchedulingAspect;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@EnableAspectJAutoProxy
@ConditionalOnProperty(value={"spring.sleuth.scheduled.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
@EnableConfigurationProperties(value={SleuthSchedulingProperties.class})
public class TraceSchedulingAutoConfiguration {
    @ConditionalOnClass(name={"org.aspectj.lang.ProceedingJoinPoint"})
    @Bean
    public TraceSchedulingAspect traceSchedulingAspect(Tracer tracer, TraceKeys traceKeys, SleuthSchedulingProperties sleuthSchedulingProperties) {
        return new TraceSchedulingAspect(tracer, traceKeys, Pattern.compile(sleuthSchedulingProperties.getSkipPattern()));
    }
}

