/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.List;
import java.util.Map;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapInjector;
import org.springframework.cloud.sleuth.util.TextMapUtil;
import org.springframework.util.StringUtils;

public class HeaderBasedMessagingInjector
implements MessagingSpanTextMapInjector {
    private final TraceKeys traceKeys;

    public HeaderBasedMessagingInjector(TraceKeys traceKeys) {
        this.traceKeys = traceKeys;
    }

    @Override
    public void inject(Span span, SpanTextMap carrier) {
        Map<String, String> map = TextMapUtil.asMap(carrier);
        if (span == null) {
            if (!this.isSampled(map, "spanSampled")) {
                carrier.put("spanSampled", "0");
                return;
            }
            return;
        }
        this.addHeaders(map, span, carrier);
    }

    private boolean isSampled(Map<String, String> initialMessage, String sampledHeaderName) {
        return "1".equals(initialMessage.get(sampledHeaderName));
    }

    private void addHeaders(Map<String, String> map, Span span, SpanTextMap textMap) {
        this.addHeader(map, textMap, "spanTraceId", span.traceIdString());
        this.addHeader(map, textMap, "spanId", Span.idToHex(span.getSpanId()));
        if (span.isExportable()) {
            this.addAnnotations(this.traceKeys, textMap, span);
            Long parentId = this.getFirst(span.getParents());
            if (parentId != null) {
                this.addHeader(map, textMap, "spanParentSpanId", Span.idToHex(parentId));
            }
            this.addHeader(map, textMap, "spanName", span.getName());
            this.addHeader(map, textMap, "spanProcessId", span.getProcessId());
            this.addHeader(map, textMap, "spanSampled", "1");
        } else {
            this.addHeader(map, textMap, "spanSampled", "0");
        }
        for (Map.Entry<String, String> entry : span.baggageItems()) {
            textMap.put(this.prefixedKey(entry.getKey()), entry.getValue());
        }
    }

    private void addAnnotations(TraceKeys traceKeys, SpanTextMap spanTextMap, Span span) {
        Map<String, String> map = TextMapUtil.asMap(spanTextMap);
        for (String name : traceKeys.getMessage().getHeaders()) {
            if (!map.containsKey(name)) continue;
            String key = traceKeys.getMessage().getPrefix() + name.toLowerCase();
            String value = map.get(name);
            if (value == null) {
                value = "null";
            }
            this.tagIfEntryMissing(span, key, value.toString());
        }
        this.addPayloadAnnotations(traceKeys, map, span);
    }

    private void addPayloadAnnotations(TraceKeys traceKeys, Map<String, String> map, Span span) {
        if (map.containsKey(traceKeys.getMessage().getPayload().getType())) {
            this.tagIfEntryMissing(span, traceKeys.getMessage().getPayload().getType(), map.get(traceKeys.getMessage().getPayload().getType()));
            this.tagIfEntryMissing(span, traceKeys.getMessage().getPayload().getSize(), map.get(traceKeys.getMessage().getPayload().getSize()));
        }
    }

    private void tagIfEntryMissing(Span span, String key, String value) {
        if (!span.tags().containsKey(key)) {
            span.tag(key, value);
        }
    }

    private void addHeader(Map<String, String> map, SpanTextMap textMap, String name, String value) {
        if (StringUtils.hasText((String)value) && !map.containsKey(name)) {
            textMap.put(name, value);
        }
    }

    private Long getFirst(List<Long> parents) {
        return parents.isEmpty() ? null : parents.get(0);
    }

    private String prefixedKey(String key) {
        if (key.startsWith("baggage_")) {
            return key;
        }
        return "baggage_" + key;
    }
}

