/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import com.netflix.client.http.HttpRequest;
import com.netflix.zuul.ZuulFilter;
import okhttp3.Request;
import org.apache.http.client.methods.RequestBuilder;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.netflix.ribbon.support.RibbonRequestCustomizer;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanInjector;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.zuul.ApacheHttpClientRibbonRequestCustomizer;
import org.springframework.cloud.sleuth.instrument.zuul.OkHttpClientRibbonRequestCustomizer;
import org.springframework.cloud.sleuth.instrument.zuul.RestClientRibbonRequestCustomizer;
import org.springframework.cloud.sleuth.instrument.zuul.TracePostZuulFilter;
import org.springframework.cloud.sleuth.instrument.zuul.TracePreZuulFilter;
import org.springframework.cloud.sleuth.instrument.zuul.TraceRibbonCommandFactoryBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.zuul.TraceZuulHandlerMappingBeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.zuul.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication
@ConditionalOnClass(value={ZuulFilter.class})
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TraceWebAutoConfiguration.class})
public class TraceZuulAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TracePreZuulFilter tracePreZuulFilter(Tracer tracer, HttpSpanInjector spanInjector, HttpTraceKeysInjector httpTraceKeysInjector, ErrorParser errorParser) {
        return new TracePreZuulFilter(tracer, spanInjector, httpTraceKeysInjector, errorParser);
    }

    @Bean
    @ConditionalOnMissingBean
    public TracePostZuulFilter tracePostZuulFilter(Tracer tracer, TraceKeys traceKeys) {
        return new TracePostZuulFilter(tracer, traceKeys);
    }

    @Bean
    public TraceRibbonCommandFactoryBeanPostProcessor traceRibbonCommandFactoryBeanPostProcessor(BeanFactory beanFactory) {
        return new TraceRibbonCommandFactoryBeanPostProcessor(beanFactory);
    }

    @Bean
    @ConditionalOnClass(name={"com.netflix.client.http.HttpRequest.Builder"})
    public RibbonRequestCustomizer<HttpRequest.Builder> restClientRibbonRequestCustomizer(Tracer tracer) {
        return new RestClientRibbonRequestCustomizer(tracer);
    }

    @Bean
    @ConditionalOnClass(name={"org.apache.http.client.methods.RequestBuilder"})
    public RibbonRequestCustomizer<RequestBuilder> apacheHttpRibbonRequestCustomizer(Tracer tracer) {
        return new ApacheHttpClientRibbonRequestCustomizer(tracer);
    }

    @Bean
    @ConditionalOnClass(name={"okhttp3.Request.Builder"})
    public RibbonRequestCustomizer<Request.Builder> okHttpRibbonRequestCustomizer(Tracer tracer) {
        return new OkHttpClientRibbonRequestCustomizer(tracer);
    }

    @Bean
    public TraceZuulHandlerMappingBeanPostProcessor traceHandlerMappingBeanPostProcessor(BeanFactory beanFactory) {
        return new TraceZuulHandlerMappingBeanPostProcessor(beanFactory);
    }
}

