/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

class MessagingTextMap
implements SpanTextMap {
    private final MessageBuilder<?> delegate;

    public MessagingTextMap(MessageBuilder<?> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        HashMap map = new HashMap();
        for (Map.Entry entry : this.delegate.build().getHeaders().entrySet()) {
            if ("nativeHeaders".equals(entry.getKey())) continue;
            map.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return map.entrySet().iterator();
    }

    @Override
    public void put(String key, String value) {
        if (!StringUtils.hasText((String)value)) {
            return;
        }
        Message initialMessage = this.delegate.build();
        MessageHeaderAccessor accessor = MessageHeaderAccessor.getMutableAccessor((Message)initialMessage);
        accessor.setHeader(key, (Object)value);
        if (accessor instanceof SimpMessageHeaderAccessor) {
            SimpMessageHeaderAccessor nativeAccessor = (SimpMessageHeaderAccessor)accessor;
            nativeAccessor.setNativeHeader(key, value);
        } else if (accessor.getHeader("nativeHeaders") != null) {
            if (accessor.getHeader("nativeHeaders") instanceof MultiValueMap) {
                MultiValueMap map = (MultiValueMap)accessor.getHeader("nativeHeaders");
                map.add((Object)key, (Object)value);
            }
        } else {
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            accessor.setHeader("nativeHeaders", (Object)map);
            map.add((Object)key, (Object)value);
        }
        this.delegate.copyHeaders((Map)accessor.toMessageHeaders());
    }
}

