/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.lang.invoke.MethodHandles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapExtractor;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapInjector;
import org.springframework.cloud.sleuth.util.SpanNameUtil;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.util.ClassUtils;

abstract class AbstractTraceChannelInterceptor
extends ChannelInterceptorAdapter
implements ExecutorChannelInterceptor {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected static final String MESSAGE_COMPONENT = "message";
    private Tracer tracer;
    private TraceKeys traceKeys;
    private MessagingSpanTextMapExtractor spanExtractor;
    private MessagingSpanTextMapInjector spanInjector;
    private ErrorParser errorParser;
    private final BeanFactory beanFactory;

    protected AbstractTraceChannelInterceptor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    protected TraceKeys getTraceKeys() {
        if (this.traceKeys == null) {
            this.traceKeys = (TraceKeys)this.beanFactory.getBean(TraceKeys.class);
        }
        return this.traceKeys;
    }

    protected MessagingSpanTextMapExtractor getSpanExtractor() {
        if (this.spanExtractor == null) {
            this.spanExtractor = (MessagingSpanTextMapExtractor)this.beanFactory.getBean(MessagingSpanTextMapExtractor.class);
        }
        return this.spanExtractor;
    }

    protected MessagingSpanTextMapInjector getSpanInjector() {
        if (this.spanInjector == null) {
            this.spanInjector = (MessagingSpanTextMapInjector)this.beanFactory.getBean(MessagingSpanTextMapInjector.class);
        }
        return this.spanInjector;
    }

    protected ErrorParser getErrorParser() {
        if (this.errorParser == null) {
            this.errorParser = (ErrorParser)this.beanFactory.getBean(ErrorParser.class);
        }
        return this.errorParser;
    }

    protected Span buildSpan(SpanTextMap carrier) {
        try {
            return this.getSpanExtractor().joinTrace(carrier);
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while trying to extract span from carrier", (Throwable)e);
            return null;
        }
    }

    String getChannelName(MessageChannel channel) {
        String name = null;
        if (ClassUtils.isPresent((String)"org.springframework.integration.context.IntegrationObjectSupport", null)) {
            if (channel instanceof IntegrationObjectSupport) {
                name = ((IntegrationObjectSupport)channel).getComponentName();
            }
            if (name == null && channel instanceof AbstractMessageChannel) {
                name = ((AbstractMessageChannel)channel).getFullChannelName();
            }
        }
        if (name == null) {
            name = channel.toString();
        }
        return name;
    }

    String getMessageChannelName(MessageChannel channel) {
        return SpanNameUtil.shorten("message:" + this.getChannelName(channel));
    }
}

