/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.annotation;

import java.lang.invoke.MethodHandles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.annotation.TagValueExpressionResolver;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;

class SpelTagValueExpressionResolver
implements TagValueExpressionResolver {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());

    SpelTagValueExpressionResolver() {
    }

    @Override
    public String resolve(String expression, Object parameter) {
        try {
            SpelExpressionParser expressionParser = new SpelExpressionParser();
            Expression expressionToEvaluate = expressionParser.parseExpression(expression);
            return (String)expressionToEvaluate.getValue(parameter, String.class);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while tying to evaluate the SPEL expression [" + expression + "]"), (Throwable)e);
            return parameter.toString();
        }
    }
}

