/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanInjector;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.client.SleuthWebClientEnabled;
import org.springframework.cloud.sleuth.instrument.web.client.TraceAsyncClientHttpRequestFactoryWrapper;
import org.springframework.cloud.sleuth.instrument.web.client.TraceAsyncListenableTaskExecutor;
import org.springframework.cloud.sleuth.instrument.web.client.TraceAsyncRestTemplate;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.client.AsyncRestTemplate;

@Configuration
@SleuthWebClientEnabled
@ConditionalOnProperty(value={"spring.sleuth.web.async.client.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={AsyncRestTemplate.class})
@ConditionalOnBean(value={HttpTraceKeysInjector.class})
@AutoConfigureAfter(value={TraceWebAutoConfiguration.class})
public class TraceWebAsyncClientAutoConfiguration {
    @Autowired
    Tracer tracer;
    @Autowired
    private HttpTraceKeysInjector httpTraceKeysInjector;
    @Autowired
    private HttpSpanInjector spanInjector;
    @Autowired(required=false)
    private ClientHttpRequestFactory clientHttpRequestFactory;
    @Autowired(required=false)
    private AsyncClientHttpRequestFactory asyncClientHttpRequestFactory;

    private TraceAsyncClientHttpRequestFactoryWrapper traceAsyncClientHttpRequestFactory() {
        ClientHttpRequestFactory clientFactory = this.clientHttpRequestFactory;
        AsyncClientHttpRequestFactory asyncClientFactory = this.asyncClientHttpRequestFactory;
        if (clientFactory == null) {
            clientFactory = this.defaultClientHttpRequestFactory(this.tracer);
        }
        if (asyncClientFactory == null) {
            asyncClientFactory = clientFactory instanceof AsyncClientHttpRequestFactory ? (AsyncClientHttpRequestFactory)clientFactory : this.defaultClientHttpRequestFactory(this.tracer);
        }
        return new TraceAsyncClientHttpRequestFactoryWrapper(this.tracer, this.spanInjector, asyncClientFactory, clientFactory, this.httpTraceKeysInjector);
    }

    private SimpleClientHttpRequestFactory defaultClientHttpRequestFactory(Tracer tracer) {
        SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        simpleClientHttpRequestFactory.setTaskExecutor(this.asyncListenableTaskExecutor(tracer));
        return simpleClientHttpRequestFactory;
    }

    private AsyncListenableTaskExecutor asyncListenableTaskExecutor(Tracer tracer) {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.initialize();
        return new TraceAsyncListenableTaskExecutor((AsyncListenableTaskExecutor)threadPoolTaskScheduler, tracer);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.sleuth.web.async.client.template.enabled"}, matchIfMissing=true)
    public AsyncRestTemplate traceAsyncRestTemplate() {
        return new TraceAsyncRestTemplate(this.traceAsyncClientHttpRequestFactory(), this.tracer);
    }
}

