/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.ExceptionMessageErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SuccessCallback;
import org.springframework.web.client.AsyncRequestCallback;
import org.springframework.web.client.AsyncRestTemplate;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class TraceAsyncRestTemplate
extends AsyncRestTemplate {
    private final Tracer tracer;
    private final ErrorParser errorParser;

    @Deprecated
    public TraceAsyncRestTemplate(Tracer tracer) {
        this.tracer = tracer;
        this.errorParser = new ExceptionMessageErrorParser();
    }

    @Deprecated
    public TraceAsyncRestTemplate(AsyncListenableTaskExecutor taskExecutor, Tracer tracer) {
        super(taskExecutor);
        this.tracer = tracer;
        this.errorParser = new ExceptionMessageErrorParser();
    }

    @Deprecated
    public TraceAsyncRestTemplate(AsyncClientHttpRequestFactory asyncRequestFactory, Tracer tracer) {
        super(asyncRequestFactory);
        this.tracer = tracer;
        this.errorParser = new ExceptionMessageErrorParser();
    }

    @Deprecated
    public TraceAsyncRestTemplate(AsyncClientHttpRequestFactory asyncRequestFactory, ClientHttpRequestFactory syncRequestFactory, Tracer tracer) {
        super(asyncRequestFactory, syncRequestFactory);
        this.tracer = tracer;
        this.errorParser = new ExceptionMessageErrorParser();
    }

    @Deprecated
    public TraceAsyncRestTemplate(AsyncClientHttpRequestFactory requestFactory, RestTemplate restTemplate, Tracer tracer) {
        super(requestFactory, restTemplate);
        this.tracer = tracer;
        this.errorParser = new ExceptionMessageErrorParser();
    }

    public TraceAsyncRestTemplate(Tracer tracer, ErrorParser errorParser) {
        this.tracer = tracer;
        this.errorParser = errorParser;
    }

    public TraceAsyncRestTemplate(AsyncListenableTaskExecutor taskExecutor, Tracer tracer, ErrorParser errorParser) {
        super(taskExecutor);
        this.tracer = tracer;
        this.errorParser = errorParser;
    }

    public TraceAsyncRestTemplate(AsyncClientHttpRequestFactory asyncRequestFactory, Tracer tracer, ErrorParser errorParser) {
        super(asyncRequestFactory);
        this.tracer = tracer;
        this.errorParser = errorParser;
    }

    public TraceAsyncRestTemplate(AsyncClientHttpRequestFactory asyncRequestFactory, ClientHttpRequestFactory syncRequestFactory, Tracer tracer, ErrorParser errorParser) {
        super(asyncRequestFactory, syncRequestFactory);
        this.tracer = tracer;
        this.errorParser = errorParser;
    }

    public TraceAsyncRestTemplate(AsyncClientHttpRequestFactory requestFactory, RestTemplate restTemplate, Tracer tracer, ErrorParser errorParser) {
        super(requestFactory, restTemplate);
        this.tracer = tracer;
        this.errorParser = errorParser;
    }

    protected <T> ListenableFuture<T> doExecute(URI url, HttpMethod method, AsyncRequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        Span parent;
        final ListenableFuture future = super.doExecute(url, method, requestCallback, responseExtractor);
        final Span span = this.tracer.getCurrentSpan();
        future.addCallback(new TraceListenableFutureCallback(this.tracer, span, this.errorParser));
        if (span != null && span.equals(this.tracer.getCurrentSpan()) && (parent = this.tracer.detach(span)) != null) {
            this.tracer.continueSpan(parent);
        }
        return new ListenableFuture<T>(){

            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            public boolean isCancelled() {
                return future.isCancelled();
            }

            public boolean isDone() {
                return future.isDone();
            }

            public T get() throws InterruptedException, ExecutionException {
                return future.get();
            }

            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return future.get(timeout, unit);
            }

            public void addCallback(ListenableFutureCallback<? super T> callback) {
                future.addCallback(new TraceListenableFutureCallbackWrapper(TraceAsyncRestTemplate.this.tracer, span, callback));
            }

            public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
                future.addCallback(new TraceSuccessCallback(TraceAsyncRestTemplate.this.tracer, span, successCallback), (FailureCallback)new TraceFailureCallback(TraceAsyncRestTemplate.this.tracer, span, failureCallback));
            }
        };
    }

    private static class TraceListenableFutureCallback<T>
    implements ListenableFutureCallback<T> {
        private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
        private final Tracer tracer;
        private final Span parent;
        private final ErrorParser errorParser;

        private TraceListenableFutureCallback(Tracer tracer, Span parent, ErrorParser errorParser) {
            this.tracer = tracer;
            this.parent = parent;
            this.errorParser = errorParser;
        }

        public void onFailure(Throwable ex) {
            this.continueSpan();
            if (log.isDebugEnabled()) {
                log.debug((Object)"The callback failed - will close the span");
            }
            this.errorParser.parseErrorTags(this.currentSpan(), ex);
            this.finish();
        }

        public void onSuccess(T result) {
            this.continueSpan();
            if (log.isDebugEnabled()) {
                log.debug((Object)"The callback succeeded - will close the span");
            }
            this.finish();
        }

        private void continueSpan() {
            this.tracer.continueSpan(this.parent);
        }

        private void finish() {
            if (!this.isTracing()) {
                return;
            }
            this.currentSpan().logEvent("cr");
            this.tracer.close(this.currentSpan());
        }

        private Span currentSpan() {
            return this.tracer.getCurrentSpan();
        }

        private boolean isTracing() {
            return this.tracer.isTracing();
        }
    }

    private static class TraceListenableFutureCallbackWrapper<T>
    implements ListenableFutureCallback<T> {
        private final Tracer tracer;
        private final Span parent;
        private final ListenableFutureCallback<T> delegate;

        private TraceListenableFutureCallbackWrapper(Tracer tracer, Span parent, ListenableFutureCallback<T> delegate) {
            this.tracer = tracer;
            this.parent = parent;
            this.delegate = delegate;
        }

        public void onFailure(Throwable ex) {
            new TraceFailureCallback(this.tracer, this.parent, (FailureCallback)this.delegate).onFailure(ex);
        }

        public void onSuccess(T result) {
            new TraceSuccessCallback<T>(this.tracer, this.parent, (SuccessCallback)this.delegate).onSuccess(result);
        }
    }

    private static class TraceFailureCallback
    implements FailureCallback {
        private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
        private final Tracer tracer;
        private final Span parent;
        private final FailureCallback delegate;

        private TraceFailureCallback(Tracer tracer, Span parent, FailureCallback delegate) {
            this.tracer = tracer;
            this.parent = parent;
            this.delegate = delegate;
        }

        public void onFailure(Throwable ex) {
            this.continueSpan();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Calling on failure of the delegate");
            }
            this.delegate.onFailure(ex);
            this.finish();
        }

        private void continueSpan() {
            this.tracer.continueSpan(this.parent);
        }

        private void finish() {
            this.tracer.detach(this.currentSpan());
        }

        private Span currentSpan() {
            return this.tracer.getCurrentSpan();
        }
    }

    private static class TraceSuccessCallback<T>
    implements SuccessCallback<T> {
        private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
        private final Tracer tracer;
        private final Span parent;
        private final SuccessCallback<T> delegate;

        private TraceSuccessCallback(Tracer tracer, Span parent, SuccessCallback<T> delegate) {
            this.tracer = tracer;
            this.parent = parent;
            this.delegate = delegate;
        }

        public void onSuccess(T result) {
            this.continueSpan();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Calling on success of the delegate");
            }
            this.delegate.onSuccess(result);
            this.finish();
        }

        private void continueSpan() {
            this.tracer.continueSpan(this.parent);
        }

        private void finish() {
            this.tracer.detach(this.currentSpan());
        }

        private Span currentSpan() {
            return this.tracer.getCurrentSpan();
        }
    }
}

