/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.Map;
import java.util.Random;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapExtractor;
import org.springframework.cloud.sleuth.util.TextMapUtil;

public class HeaderBasedMessagingExtractor
implements MessagingSpanTextMapExtractor {
    private final Random random = new Random();

    @Override
    public Span joinTrace(SpanTextMap textMap) {
        boolean traceIdMissing;
        Map<String, String> carrier = TextMapUtil.asMap(textMap);
        boolean spanIdMissing = !this.hasHeader(carrier, "spanId");
        boolean bl = traceIdMissing = !this.hasHeader(carrier, "spanTraceId");
        if ("1".equals(carrier.get("spanFlags"))) {
            String traceId = this.generateTraceIdIfMissing(carrier, traceIdMissing);
            if (spanIdMissing) {
                carrier.put("spanId", traceId);
            }
        } else if (!this.hasHeader(carrier, "spanId") || !this.hasHeader(carrier, "spanTraceId")) {
            return null;
        }
        boolean idMissing = spanIdMissing || traceIdMissing;
        return this.extractSpanFromHeaders(carrier, Span.builder(), idMissing);
    }

    private String generateTraceIdIfMissing(Map<String, String> carrier, boolean traceIdMissing) {
        if (traceIdMissing) {
            carrier.put("spanTraceId", Span.idToHex(this.random.nextLong()));
        }
        return carrier.get("spanTraceId");
    }

    private Span extractSpanFromHeaders(Map<String, String> carrier, Span.SpanBuilder spanBuilder, boolean idMissing) {
        String traceId = carrier.get("spanTraceId");
        spanBuilder = spanBuilder.traceIdHigh(traceId.length() == 32 ? Span.hexToId(traceId, 0) : 0L).traceId(Span.hexToId(traceId)).spanId(Span.hexToId(carrier.get("spanId")));
        String flags = carrier.get("spanFlags");
        boolean debug = "1".equals(flags);
        boolean spanSampled = "1".equals(carrier.get("spanSampled"));
        if (debug) {
            spanBuilder.exportable(true);
        } else {
            spanBuilder.exportable(spanSampled);
        }
        String processId = carrier.get("spanProcessId");
        String spanName = carrier.get("spanName");
        if (spanName != null) {
            spanBuilder.name(spanName);
        }
        if (processId != null) {
            spanBuilder.processId(processId);
        }
        this.setParentIdIfApplicable(carrier, spanBuilder, "spanParentSpanId");
        spanBuilder.remote(true);
        spanBuilder.shared((debug || spanSampled) && !idMissing);
        for (Map.Entry<String, String> entry : carrier.entrySet()) {
            if (!entry.getKey().toLowerCase().startsWith("baggage_")) continue;
            spanBuilder.baggage(this.unprefixedKey(entry.getKey()), entry.getValue());
        }
        return spanBuilder.build();
    }

    boolean hasHeader(Map<String, String> message, String name) {
        return message.containsKey(name);
    }

    private void setParentIdIfApplicable(Map<String, String> carrier, Span.SpanBuilder spanBuilder, String spanParentIdHeader) {
        String parentId = carrier.get(spanParentIdHeader);
        if (parentId != null) {
            spanBuilder.parent(Span.hexToId(parentId));
        }
    }

    private String unprefixedKey(String key) {
        return key.substring(key.indexOf("_") + 1).toLowerCase();
    }
}

