/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.async.ExecutorMethodInterceptor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.ReflectionUtils;

class ExecutorBeanPostProcessor
implements BeanPostProcessor {
    private static final Log log = LogFactory.getLog(ExecutorBeanPostProcessor.class);
    private final BeanFactory beanFactory;

    ExecutorBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Executor && !(bean instanceof ThreadPoolTaskExecutor)) {
            Method execute = ReflectionUtils.findMethod(bean.getClass(), (String)"execute", (Class[])new Class[]{Runnable.class});
            boolean methodFinal = Modifier.isFinal(execute.getModifiers());
            boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
            boolean cglibProxy = !methodFinal && !classFinal;
            Executor executor = (Executor)bean;
            try {
                return this.createProxy(bean, cglibProxy, executor);
            }
            catch (AopConfigException e) {
                if (cglibProxy) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Exception occurred while trying to create a proxy, falling back to JDK proxy", (Throwable)e);
                    }
                    return this.createProxy(bean, false, executor);
                }
                throw e;
            }
        }
        return bean;
    }

    Object createProxy(Object bean, boolean cglibProxy, Executor executor) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(cglibProxy);
        factory.addAdvice((Advice)new ExecutorMethodInterceptor(executor, this.beanFactory));
        factory.setTarget(bean);
        return factory.getObject();
    }
}

