/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.annotation;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.DynamicMethodMatcherPointcut;
import org.springframework.aop.support.annotation.AnnotationClassFilter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.cloud.sleuth.annotation.ContinueSpan;
import org.springframework.cloud.sleuth.annotation.NewSpan;
import org.springframework.cloud.sleuth.annotation.SleuthAnnotationUtils;
import org.springframework.cloud.sleuth.annotation.SleuthInterceptor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

class SleuthAdvisorConfig
extends AbstractPointcutAdvisor
implements IntroductionAdvisor,
BeanFactoryAware {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private Advice advice;
    private Pointcut pointcut;
    private BeanFactory beanFactory;

    SleuthAdvisorConfig() {
    }

    @PostConstruct
    public void init() {
        this.pointcut = this.buildPointcut();
        this.advice = this.buildAdvice();
        if (this.advice instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.advice).setBeanFactory(this.beanFactory);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public ClassFilter getClassFilter() {
        return this.pointcut.getClassFilter();
    }

    public Class<?>[] getInterfaces() {
        return new Class[0];
    }

    public void validateInterfaces() throws IllegalArgumentException {
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    private Advice buildAdvice() {
        return new SleuthInterceptor();
    }

    private Pointcut buildPointcut() {
        return new AnnotationClassOrMethodOrArgsPointcut();
    }

    private static class AnnotationMethodsResolver {
        private Class<? extends Annotation> annotationType;

        public AnnotationMethodsResolver(Class<? extends Annotation> annotationType) {
            this.annotationType = annotationType;
        }

        public boolean hasAnnotatedMethods(Class<?> clazz) {
            final AtomicBoolean found = new AtomicBoolean(false);
            ReflectionUtils.doWithMethods(clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    if (found.get()) {
                        return;
                    }
                    Annotation annotation = AnnotationUtils.findAnnotation((Method)method, (Class)AnnotationMethodsResolver.this.annotationType);
                    if (annotation != null) {
                        found.set(true);
                    }
                }
            });
            return found.get();
        }
    }

    private final class AnnotationClassOrMethodFilter
    extends AnnotationClassFilter {
        private final AnnotationMethodsResolver methodResolver;

        AnnotationClassOrMethodFilter(Class<? extends Annotation> annotationType) {
            super(annotationType, true);
            this.methodResolver = new AnnotationMethodsResolver(annotationType);
        }

        public boolean matches(Class<?> clazz) {
            return super.matches(clazz) || this.methodResolver.hasAnnotatedMethods(clazz);
        }
    }

    private final class AnnotationClassOrMethodOrArgsPointcut
    extends DynamicMethodMatcherPointcut {
        private final DynamicMethodMatcherPointcut methodResolver;

        AnnotationClassOrMethodOrArgsPointcut() {
            this.methodResolver = new DynamicMethodMatcherPointcut(){

                public boolean matches(Method method, Class<?> targetClass, Object ... args) {
                    if (SleuthAnnotationUtils.isMethodAnnotated(method)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Found a method with Sleuth annotation");
                        }
                        return true;
                    }
                    if (SleuthAnnotationUtils.hasAnnotatedParams(method, args)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Found annotated arguments of the method");
                        }
                        return true;
                    }
                    return false;
                }
            };
        }

        public boolean matches(Method method, Class<?> targetClass, Object ... args) {
            return this.getClassFilter().matches(targetClass) || this.methodResolver.matches(method, targetClass, args);
        }

        public ClassFilter getClassFilter() {
            return new ClassFilter(){

                public boolean matches(Class<?> clazz) {
                    return new AnnotationClassOrMethodFilter(NewSpan.class).matches(clazz) || new AnnotationClassOrMethodFilter(ContinueSpan.class).matches(clazz);
                }
            };
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationClassOrMethodOrArgsPointcut)) {
                return false;
            }
            AnnotationClassOrMethodOrArgsPointcut otherAdvisor = (AnnotationClassOrMethodOrArgsPointcut)((Object)other);
            return ObjectUtils.nullSafeEquals((Object)this.methodResolver, (Object)otherAdvisor.methodResolver);
        }
    }
}

