/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import com.netflix.client.http.HttpRequest;
import com.netflix.niws.client.http.RestClient;
import java.io.InputStream;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.netflix.zuul.filters.route.RestClientRibbonCommand;
import org.springframework.cloud.netflix.zuul.filters.route.RestClientRibbonCommandFactory;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.util.MultiValueMap;

public class TraceRestClientRibbonCommandFactory
extends RestClientRibbonCommandFactory {
    private static final Log log = LogFactory.getLog(TraceRestClientRibbonCommandFactory.class);
    private final Tracer tracer;
    private final SpanInjector<HttpRequest.Builder> spanInjector;
    private final HttpTraceKeysInjector httpTraceKeysInjector;

    public TraceRestClientRibbonCommandFactory(SpringClientFactory clientFactory, Tracer tracer, SpanInjector<HttpRequest.Builder> spanInjector, HttpTraceKeysInjector httpTraceKeysInjector) {
        super(clientFactory);
        this.tracer = tracer;
        this.spanInjector = spanInjector;
        this.httpTraceKeysInjector = httpTraceKeysInjector;
    }

    public RestClientRibbonCommand create(RibbonCommandContext context) {
        RestClient restClient = (RestClient)this.getClientFactory().getClient(context.getServiceId(), RestClient.class);
        try {
            return new TraceRestClientRibbonCommand(context.getServiceId(), restClient, TraceRestClientRibbonCommandFactory.getVerb((String)context.getVerb()), context.getUri(), context.getRetryable(), (MultiValueMap<String, String>)context.getHeaders(), (MultiValueMap<String, String>)context.getParams(), context.getRequestEntity(), this.tracer, this.spanInjector, this.httpTraceKeysInjector);
        }
        catch (URISyntaxException e) {
            log.error((Object)"Exception occurred while trying to create the TraceRestClientRibbonCommand", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    class TraceRestClientRibbonCommand
    extends RestClientRibbonCommand {
        private final Tracer tracer;
        private final SpanInjector<HttpRequest.Builder> spanInjector;
        private final HttpTraceKeysInjector httpTraceKeysInjector;

        public TraceRestClientRibbonCommand(String commandKey, RestClient restClient, HttpRequest.Verb verb, String uri, Boolean retryable, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity, Tracer tracer, SpanInjector<HttpRequest.Builder> spanInjector, HttpTraceKeysInjector httpTraceKeysInjector) throws URISyntaxException {
            super(commandKey, restClient, verb, uri, retryable, headers, params, requestEntity);
            this.tracer = tracer;
            this.spanInjector = spanInjector;
            this.httpTraceKeysInjector = httpTraceKeysInjector;
        }

        protected void customizeRequest(HttpRequest.Builder requestBuilder) {
            Span span = this.getCurrentSpan();
            this.spanInjector.inject(span, requestBuilder);
            this.httpTraceKeysInjector.addRequestTags(span, this.getUri(), this.getVerb().verb());
            span.logEvent("cs");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Span in RibbonCommandFactory is" + span));
            }
        }

        private Span getCurrentSpan() {
            return this.tracer.getCurrentSpan();
        }
    }
}

