/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import com.netflix.zuul.context.RequestContext;
import java.util.Map;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.util.StringUtils;

class RequestContextInjector
implements SpanInjector<RequestContext> {
    RequestContextInjector() {
    }

    @Override
    public void inject(Span span, RequestContext carrier) {
        Map requestHeaders = carrier.getZuulRequestHeaders();
        if (span == null) {
            this.setHeader((Map<String, String>)requestHeaders, "X-B3-Sampled", "0");
            return;
        }
        this.setHeader((Map<String, String>)requestHeaders, "X-B3-SpanId", span.getSpanId());
        this.setHeader((Map<String, String>)requestHeaders, "X-B3-TraceId", span.traceIdString());
        this.setHeader((Map<String, String>)requestHeaders, "X-Span-Name", span.getName());
        this.setHeader((Map<String, String>)requestHeaders, "X-B3-Sampled", span.isExportable() ? "1" : "0");
        this.setHeader((Map<String, String>)requestHeaders, "X-B3-ParentSpanId", this.getParentId(span));
        this.setHeader((Map<String, String>)requestHeaders, "X-Process-Id", span.getProcessId());
    }

    private Long getParentId(Span span) {
        return !span.getParents().isEmpty() ? span.getParents().get(0) : null;
    }

    public void setHeader(Map<String, String> request, String name, String value) {
        if (StringUtils.hasText((String)value) && !request.containsKey(name)) {
            request.put(name, value);
        }
    }

    public void setHeader(Map<String, String> request, String name, Long value) {
        if (value != null) {
            this.setHeader(request, name, Span.idToHex(value));
        }
    }
}

