/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.client.HttpRequestInjector;
import org.springframework.cloud.sleuth.instrument.web.client.SleuthWebClientEnabled;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRestTemplateInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpRequest;
import org.springframework.web.client.RestTemplate;

@Configuration
@SleuthWebClientEnabled
@ConditionalOnClass(value={RestTemplate.class})
@ConditionalOnBean(value={HttpTraceKeysInjector.class})
@AutoConfigureAfter(value={TraceWebAutoConfiguration.class})
public class TraceWebClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TraceRestTemplateInterceptor traceRestTemplateInterceptor(Tracer tracer, SpanInjector<HttpRequest> spanInjector, HttpTraceKeysInjector httpTraceKeysInjector) {
        return new TraceRestTemplateInterceptor(tracer, spanInjector, httpTraceKeysInjector);
    }

    @Bean
    public SpanInjector<HttpRequest> httpRequestSpanInjector() {
        return new HttpRequestInjector();
    }

    @Configuration
    protected static class TraceInterceptorConfiguration {
        @Autowired(required=false)
        private Collection<RestTemplate> restTemplates;
        @Autowired
        private TraceRestTemplateInterceptor traceRestTemplateInterceptor;

        protected TraceInterceptorConfiguration() {
        }

        @PostConstruct
        public void init() {
            if (this.restTemplates != null) {
                for (RestTemplate restTemplate : this.restTemplates) {
                    ArrayList<TraceRestTemplateInterceptor> interceptors = new ArrayList<TraceRestTemplateInterceptor>(restTemplate.getInterceptors());
                    interceptors.add(this.traceRestTemplateInterceptor);
                    restTemplate.setInterceptors(interceptors);
                }
            }
        }
    }
}

