/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.util.ExceptionUtils;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.client.AsyncRequestCallback;
import org.springframework.web.client.AsyncRestTemplate;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class TraceAsyncRestTemplate
extends AsyncRestTemplate {
    private final Tracer tracer;

    public TraceAsyncRestTemplate(Tracer tracer) {
        this.tracer = tracer;
    }

    public TraceAsyncRestTemplate(AsyncListenableTaskExecutor taskExecutor, Tracer tracer) {
        super(taskExecutor);
        this.tracer = tracer;
    }

    public TraceAsyncRestTemplate(AsyncClientHttpRequestFactory asyncRequestFactory, Tracer tracer) {
        super(asyncRequestFactory);
        this.tracer = tracer;
    }

    public TraceAsyncRestTemplate(AsyncClientHttpRequestFactory asyncRequestFactory, ClientHttpRequestFactory syncRequestFactory, Tracer tracer) {
        super(asyncRequestFactory, syncRequestFactory);
        this.tracer = tracer;
    }

    public TraceAsyncRestTemplate(AsyncClientHttpRequestFactory requestFactory, RestTemplate restTemplate, Tracer tracer) {
        super(requestFactory, restTemplate);
        this.tracer = tracer;
    }

    protected <T> ListenableFuture<T> doExecute(URI url, HttpMethod method, AsyncRequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        ListenableFuture future = super.doExecute(url, method, requestCallback, responseExtractor);
        Span span = this.tracer.getCurrentSpan();
        future.addCallback(new TraceListenableFutureCallback(this.tracer, span));
        if (span != null && span.equals(this.tracer.getCurrentSpan())) {
            this.tracer.detach(span);
        }
        return future;
    }

    private static class TraceListenableFutureCallback<T>
    implements ListenableFutureCallback<T> {
        private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
        private final Tracer tracer;
        private final Span parent;

        private TraceListenableFutureCallback(Tracer tracer, Span parent) {
            this.tracer = tracer;
            this.parent = parent;
        }

        public void onFailure(Throwable ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The callback failed - will close the span");
            }
            this.continueSpan();
            this.tracer.addTag("error", ExceptionUtils.getExceptionMessage(ex));
            this.finish();
        }

        public void onSuccess(T result) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The callback succeeded - will close the span");
            }
            this.continueSpan();
            this.finish();
        }

        private void continueSpan() {
            this.tracer.continueSpan(this.parent);
        }

        private void finish() {
            if (!this.isTracing()) {
                return;
            }
            this.currentSpan().logEvent("cr");
            this.tracer.close(this.currentSpan());
        }

        private Span currentSpan() {
            return this.tracer.getCurrentSpan();
        }

        private boolean isTracing() {
            return this.tracer.isTracing();
        }
    }
}

