/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.util.StringUtils;

public class HttpTraceKeysInjector {
    private final Tracer tracer;
    private final TraceKeys traceKeys;

    public HttpTraceKeysInjector(Tracer tracer, TraceKeys traceKeys) {
        this.tracer = tracer;
        this.traceKeys = traceKeys;
    }

    public void addRequestTags(String url, String host, String path, String method) {
        this.tracer.addTag(this.traceKeys.getHttp().getUrl(), url);
        this.tracer.addTag(this.traceKeys.getHttp().getHost(), host);
        this.tracer.addTag(this.traceKeys.getHttp().getPath(), path);
        this.tracer.addTag(this.traceKeys.getHttp().getMethod(), method);
    }

    public void addRequestTags(Span span, String url, String host, String path, String method) {
        this.tagSpan(span, this.traceKeys.getHttp().getUrl(), url);
        this.tagSpan(span, this.traceKeys.getHttp().getHost(), host);
        this.tagSpan(span, this.traceKeys.getHttp().getPath(), path);
        this.tagSpan(span, this.traceKeys.getHttp().getMethod(), method);
    }

    public void addRequestTags(Span span, URI uri, String method) {
        this.addRequestTags(span, uri.toString(), uri.getHost(), uri.getPath(), method);
    }

    public void addRequestTags(String url, String host, String path, String method, Map<String, ? extends Collection<String>> headers) {
        this.addRequestTags(url, host, path, method);
        this.addRequestTagsFromHeaders(headers);
    }

    public void tagSpan(Span span, String key, String value) {
        if (span != null && span.isExportable()) {
            span.tag(key, value);
        }
    }

    private void addRequestTagsFromHeaders(Map<String, ? extends Collection<String>> headers) {
        for (String name : this.traceKeys.getHttp().getHeaders()) {
            for (Map.Entry<String, ? extends Collection<String>> entry : headers.entrySet()) {
                this.addTagForEntry(name, entry.getValue());
            }
        }
    }

    private void addTagForEntry(String name, Collection<String> list) {
        String key = this.traceKeys.getHttp().getPrefix() + name.toLowerCase();
        String value = list.size() == 1 ? list.iterator().next() : StringUtils.collectionToDelimitedString(list, (String)",", (String)"'", (String)"'");
        this.tracer.addTag(key, value);
    }
}

