/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.lang.invoke.MethodHandles;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanExtractor;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UrlPathHelper;

class HttpServletRequestExtractor
implements SpanExtractor<HttpServletRequest> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String HTTP_COMPONENT = "http";
    private final Pattern skipPattern;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    public HttpServletRequestExtractor(Pattern skipPattern) {
        this.skipPattern = skipPattern;
    }

    @Override
    public Span joinTrace(HttpServletRequest carrier) {
        if (carrier.getHeader("X-B3-TraceId") == null) {
            return null;
        }
        try {
            String uri = this.urlPathHelper.getPathWithinApplication(carrier);
            boolean skip = this.skipPattern.matcher(uri).matches() || "0".equals(carrier.getHeader("X-B3-Sampled"));
            long spanId = this.spanId(carrier);
            return this.buildParentSpan(carrier, uri, skip, spanId);
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while trying to extract span from carrier", (Throwable)e);
            return null;
        }
    }

    private long spanId(HttpServletRequest carrier) {
        String spanId = carrier.getHeader("X-B3-SpanId");
        if (spanId == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Request is missing a span id but it has a trace id. We'll assume that this is a root span with span id equal to the lower 64-bits of the trace id");
            }
            return Span.hexToId(carrier.getHeader("X-B3-TraceId"));
        }
        return Span.hexToId(spanId);
    }

    private Span buildParentSpan(HttpServletRequest carrier, String uri, boolean skip, long spanId) {
        String traceId = carrier.getHeader("X-B3-TraceId");
        Span.SpanBuilder span = Span.builder().traceIdHigh(traceId.length() == 32 ? Span.hexToId(traceId, 0) : 0L).traceId(Span.hexToId(traceId)).spanId(spanId);
        String processId = carrier.getHeader("X-Process-Id");
        String parentName = carrier.getHeader("X-Span-Name");
        if (StringUtils.hasText((String)parentName)) {
            span.name(parentName);
        } else {
            span.name("http:/parent" + uri);
        }
        if (StringUtils.hasText((String)processId)) {
            span.processId(processId);
        }
        if (carrier.getHeader("X-B3-ParentSpanId") != null) {
            span.parent(Span.hexToId(carrier.getHeader("X-B3-ParentSpanId")));
        }
        span.remote(true);
        if (skip) {
            span.exportable(false);
        }
        return span.build();
    }
}

