/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.Random;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.SpanExtractor;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.messaging.IntegrationTraceChannelInterceptor;
import org.springframework.cloud.sleuth.instrument.messaging.TraceChannelInterceptor;
import org.springframework.cloud.sleuth.instrument.messaging.TraceSpanMessagingAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.config.GlobalChannelInterceptor;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

@Configuration
@ConditionalOnClass(value={GlobalChannelInterceptor.class})
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class, TraceSpanMessagingAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.integration.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={TraceKeys.class})
public class TraceSpringIntegrationAutoConfiguration {
    @Bean
    @GlobalChannelInterceptor(patterns={"#{environment.getProperty('spring.sleuth.integration.patterns') ?: '*'}"})
    public TraceChannelInterceptor traceChannelInterceptor(Tracer tracer, TraceKeys traceKeys, Random random, SpanExtractor<Message<?>> spanExtractor, SpanInjector<MessageBuilder<?>> spanInjector) {
        return new IntegrationTraceChannelInterceptor(tracer, traceKeys, spanExtractor, spanInjector);
    }
}

