/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.Random;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.sleuth.SpanExtractor;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanExtractor;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanInjector;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

@Configuration
@ConditionalOnClass(value={Message.class})
@ConditionalOnBean(value={Tracer.class})
public class TraceSpanMessagingAutoConfiguration {
    @Bean
    public SpanExtractor<Message<?>> messagingSpanExtractor(Random random) {
        return new MessagingSpanExtractor(random);
    }

    @Bean
    public SpanInjector<MessageBuilder<?>> messagingSpanInjector(TraceKeys traceKeys) {
        return new MessagingSpanInjector(traceKeys);
    }
}

