/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.lang.invoke.MethodHandles;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanExtractor;
import org.springframework.messaging.Message;

class MessagingSpanExtractor
implements SpanExtractor<Message<?>> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Random random;

    public MessagingSpanExtractor(Random random) {
        this.random = random;
    }

    @Override
    public Span joinTrace(Message<?> carrier) {
        if (!(this.hasHeader(carrier, "X-B3-TraceId") && this.hasHeader(carrier, "X-B3-SpanId") || this.hasHeader(carrier, "spanId") && this.hasHeader(carrier, "spanTraceId"))) {
            return null;
        }
        if (this.hasHeader(carrier, "X-B3-TraceId") || this.hasHeader(carrier, "X-B3-SpanId")) {
            log.warn((Object)"Deprecated trace headers detected. Please upgrade Sleuth to 1.2 or start sending headers present in the TraceMessageHeaders class");
            return this.extractSpanFromOldHeaders(carrier, Span.builder());
        }
        return this.extractSpanFromNewHeaders(carrier, Span.builder());
    }

    private Span extractSpanFromOldHeaders(Message<?> carrier, Span.SpanBuilder spanBuilder) {
        return this.extractSpanFromHeaders(carrier, spanBuilder, "X-B3-TraceId", "X-B3-SpanId", "X-B3-Sampled", "X-Process-Id", "X-Span-Name", "X-B3-ParentSpanId");
    }

    private Span extractSpanFromNewHeaders(Message<?> carrier, Span.SpanBuilder spanBuilder) {
        return this.extractSpanFromHeaders(carrier, spanBuilder, "spanTraceId", "spanId", "spanSampled", "spanProcessId", "spanName", "spanParentSpanId");
    }

    private Span extractSpanFromHeaders(Message<?> carrier, Span.SpanBuilder spanBuilder, String traceIdHeader, String spanIdHeader, String spanSampledHeader, String spanProcessIdHeader, String spanNameHeader, String spanParentIdHeader) {
        String traceId = this.getHeader(carrier, traceIdHeader);
        spanBuilder.traceIdHigh(traceId.length() == 32 ? Span.hexToId(traceId, 0) : 0L);
        spanBuilder.traceId(Span.hexToId(traceId));
        long spanId = this.hasHeader(carrier, spanIdHeader) ? Span.hexToId(this.getHeader(carrier, spanIdHeader)) : this.random.nextLong();
        spanBuilder = spanBuilder.spanId(spanId);
        spanBuilder.exportable("1".equals(this.getHeader(carrier, spanSampledHeader)));
        String processId = this.getHeader(carrier, spanProcessIdHeader);
        String spanName = this.getHeader(carrier, spanNameHeader);
        if (spanName != null) {
            spanBuilder.name(spanName);
        }
        if (processId != null) {
            spanBuilder.processId(processId);
        }
        this.setParentIdIfApplicable(carrier, spanBuilder, spanParentIdHeader);
        spanBuilder.remote(true);
        return spanBuilder.build();
    }

    String getHeader(Message<?> message, String name) {
        return this.getHeader(message, name, String.class);
    }

    <T> T getHeader(Message<?> message, String name, Class<T> type) {
        return (T)message.getHeaders().get((Object)name, type);
    }

    boolean hasHeader(Message<?> message, String name) {
        return message.getHeaders().containsKey((Object)name);
    }

    private void setParentIdIfApplicable(Message<?> carrier, Span.SpanBuilder spanBuilder, String spanParentIdHeader) {
        String parentId = this.getHeader(carrier, spanParentIdHeader);
        if (parentId != null) {
            spanBuilder.parent(Span.hexToId(parentId));
        }
    }
}

