/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.lang.invoke.MethodHandles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanExtractor;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.util.SpanNameUtil;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.ClassUtils;

abstract class AbstractTraceChannelInterceptor
extends ChannelInterceptorAdapter
implements ExecutorChannelInterceptor {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected static final String MESSAGE_COMPONENT = "message";
    private final Tracer tracer;
    private final TraceKeys traceKeys;
    private final SpanExtractor<Message<?>> spanExtractor;
    private final SpanInjector<MessageBuilder<?>> spanInjector;

    protected AbstractTraceChannelInterceptor(Tracer tracer, TraceKeys traceKeys, SpanExtractor<Message<?>> spanExtractor, SpanInjector<MessageBuilder<?>> spanInjector) {
        this.tracer = tracer;
        this.traceKeys = traceKeys;
        this.spanExtractor = spanExtractor;
        this.spanInjector = spanInjector;
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    protected TraceKeys getTraceKeys() {
        return this.traceKeys;
    }

    protected SpanInjector<MessageBuilder<?>> getSpanInjector() {
        return this.spanInjector;
    }

    protected Span buildSpan(Message<?> message) {
        try {
            return this.spanExtractor.joinTrace(message);
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while trying to extract span from carrier", (Throwable)e);
            return null;
        }
    }

    String getChannelName(MessageChannel channel) {
        String name = null;
        if (ClassUtils.isPresent((String)"org.springframework.integration.context.IntegrationObjectSupport", null)) {
            if (channel instanceof IntegrationObjectSupport) {
                name = ((IntegrationObjectSupport)channel).getComponentName();
            }
            if (name == null && channel instanceof AbstractMessageChannel) {
                name = ((AbstractMessageChannel)channel).getFullChannelName();
            }
        }
        if (name == null) {
            name = channel.toString();
        }
        return name;
    }

    String getMessageChannelName(MessageChannel channel) {
        return SpanNameUtil.shorten("message:" + this.getChannelName(channel));
    }
}

