/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.handler.MutableSpan;
import java.util.Collection;
import java.util.Map;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;

public class BraveFinishedSpan
implements FinishedSpan {
    private final MutableSpan mutableSpan;

    public BraveFinishedSpan(MutableSpan mutableSpan) {
        this.mutableSpan = mutableSpan;
    }

    public String getName() {
        return this.mutableSpan.name();
    }

    public long getStartTimestamp() {
        return this.mutableSpan.startTimestamp();
    }

    public long getEndTimestamp() {
        return this.mutableSpan.finishTimestamp();
    }

    public Map<String, String> getTags() {
        return this.mutableSpan.tags();
    }

    public Collection<Map.Entry<Long, String>> getEvents() {
        return this.mutableSpan.annotations();
    }

    public String getSpanId() {
        return this.mutableSpan.id();
    }

    public String getParentId() {
        return this.mutableSpan.parentId();
    }

    public String getRemoteIp() {
        return this.mutableSpan.remoteIp();
    }

    public String getLocalIp() {
        return this.mutableSpan.localIp();
    }

    public int getRemotePort() {
        return this.mutableSpan.remotePort();
    }

    public String getTraceId() {
        return this.mutableSpan.traceId();
    }

    public Throwable getError() {
        return this.mutableSpan.error();
    }

    public Span.Kind getKind() {
        if (this.mutableSpan.kind() == null) {
            return null;
        }
        return Span.Kind.valueOf((String)this.mutableSpan.kind().name());
    }

    public String getRemoteServiceName() {
        return this.mutableSpan.remoteServiceName();
    }

    public static FinishedSpan fromBrave(MutableSpan mutableSpan) {
        return new BraveFinishedSpan(mutableSpan);
    }

    public static MutableSpan toBrave(FinishedSpan mutableSpan) {
        return ((BraveFinishedSpan)mutableSpan).mutableSpan;
    }

    public String toString() {
        return "BraveFinishedSpan{mutableSpan=" + this.mutableSpan + '}';
    }
}

