/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.zipkin2;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinBraveConfiguration;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinSenderConfigurationImportSelector;
import org.springframework.cloud.sleuth.zipkin2.DefaultEndpointLocator;
import org.springframework.cloud.sleuth.zipkin2.DefaultZipkinRestTemplateCustomizer;
import org.springframework.cloud.sleuth.zipkin2.EndpointLocator;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;
import org.springframework.cloud.sleuth.zipkin2.ZipkinRestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import zipkin2.CheckResult;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.InMemoryReporterMetrics;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.Sender;
import zipkin2.reporter.metrics.micrometer.MicrometerReporterMetrics;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ZipkinProperties.class})
@ConditionalOnClass(value={Sender.class, EndpointLocator.class})
@ConditionalOnProperty(value={"spring.sleuth.enabled", "spring.zipkin.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(name={"org.springframework.cloud.autoconfigure.RefreshAutoConfiguration"})
@AutoConfigureBefore(value={BraveAutoConfiguration.class})
@Import(value={ZipkinSenderConfigurationImportSelector.class, ZipkinBraveConfiguration.class})
public class ZipkinAutoConfiguration {
    public static final String REPORTER_BEAN_NAME = "zipkinReporter";
    public static final String SENDER_BEAN_NAME = "zipkinSender";
    private static final Log log = LogFactory.getLog(ZipkinAutoConfiguration.class);

    static CheckResult checkResult(final Sender sender, long deadlineMillis) {
        final CheckResult[] outcome = new CheckResult[1];
        Thread thread = new Thread(sender + " check()"){

            @Override
            public void run() {
                try {
                    outcome[0] = sender.check();
                }
                catch (Throwable e) {
                    outcome[0] = CheckResult.failed((Throwable)e);
                }
            }
        };
        thread.start();
        try {
            thread.join(deadlineMillis);
            if (outcome[0] != null) {
                return outcome[0];
            }
            thread.interrupt();
            return CheckResult.failed((Throwable)new TimeoutException(thread.getName() + " timed out after " + deadlineMillis + "ms"));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return CheckResult.failed((Throwable)e);
        }
    }

    @Bean(value={"zipkinReporter"})
    @ConditionalOnMissingBean(name={"zipkinReporter"})
    Reporter<Span> reporter(ReporterMetrics reporterMetrics, ZipkinProperties zipkin, @Qualifier(value="zipkinSender") Sender sender) {
        CheckResult checkResult = ZipkinAutoConfiguration.checkResult(sender, 1000L);
        this.logCheckResult(sender, checkResult);
        AsyncReporter asyncReporter = AsyncReporter.builder((Sender)sender).queuedMaxSpans(1000).messageTimeout((long)zipkin.getMessageTimeout(), TimeUnit.SECONDS).metrics(reporterMetrics).build((BytesEncoder)zipkin.getEncoder());
        return asyncReporter;
    }

    private void logCheckResult(Sender sender, CheckResult checkResult) {
        if (log.isDebugEnabled() && checkResult != null && checkResult.ok()) {
            log.debug((Object)("Check result of the [" + sender.toString() + "] is [" + checkResult + "]"));
        } else if (checkResult != null && !checkResult.ok()) {
            log.warn((Object)("Check result of the [" + sender.toString() + "] contains an error [" + checkResult + "]"));
        }
    }

    @Bean
    @ConditionalOnMissingBean
    ZipkinRestTemplateCustomizer zipkinRestTemplateCustomizer(ZipkinProperties zipkinProperties) {
        return new DefaultZipkinRestTemplateCustomizer(zipkinProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    ReporterMetrics sleuthReporterMetrics() {
        return new InMemoryReporterMetrics();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MeterRegistry.class})
    static class TraceMetricsMicrometerConfiguration {
        TraceMetricsMicrometerConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnMissingBean(value={ReporterMetrics.class})
        static class NoReporterMetricsBeanConfiguration {
            NoReporterMetricsBeanConfiguration() {
            }

            @Bean
            @ConditionalOnBean(value={MeterRegistry.class})
            @ConditionalOnClass(name={"zipkin2.reporter.metrics.micrometer.MicrometerReporterMetrics"})
            ReporterMetrics sleuthMicrometerReporterMetrics(MeterRegistry meterRegistry) {
                return MicrometerReporterMetrics.create((MeterRegistry)meterRegistry);
            }

            @Bean
            @ConditionalOnMissingClass(value={"zipkin2.reporter.metrics.micrometer.MicrometerReporterMetrics"})
            ReporterMetrics sleuthReporterMetrics() {
                return new InMemoryReporterMetrics();
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"io.micrometer.core.instrument.MeterRegistry"})
    static class TraceMetricsInMemoryConfiguration {
        TraceMetricsInMemoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ReporterMetrics sleuthReporterMetrics() {
            return new InMemoryReporterMetrics();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Registration.class})
    @ConditionalOnMissingBean(value={EndpointLocator.class})
    @ConditionalOnProperty(value={"spring.zipkin.locator.discovery.enabled"}, havingValue="true")
    protected static class RegistrationEndpointLocatorConfiguration {
        @Autowired(required=false)
        private ServerProperties serverProperties;
        @Autowired
        private ZipkinProperties zipkinProperties;
        @Autowired(required=false)
        private InetUtils inetUtils;
        @Autowired
        private Environment environment;
        @Autowired(required=false)
        private Registration registration;

        protected RegistrationEndpointLocatorConfiguration() {
        }

        @Bean
        public EndpointLocator zipkinEndpointLocator() {
            return new DefaultEndpointLocator(this.registration, this.serverProperties, this.environment, this.zipkinProperties, this.inetUtils);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={EndpointLocator.class})
    @ConditionalOnProperty(value={"spring.zipkin.locator.discovery.enabled"}, havingValue="false", matchIfMissing=true)
    protected static class DefaultEndpointLocatorConfiguration {
        @Autowired(required=false)
        private ServerProperties serverProperties;
        @Autowired
        private ZipkinProperties zipkinProperties;
        @Autowired(required=false)
        private InetUtils inetUtils;
        @Autowired
        private Environment environment;

        protected DefaultEndpointLocatorConfiguration() {
        }

        @Bean
        public EndpointLocator zipkinEndpointLocator() {
            return new DefaultEndpointLocator(null, this.serverProperties, this.environment, this.zipkinProperties, this.inetUtils);
        }
    }
}

