/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.support;

import feign.FeignException;
import feign.Response;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.openfeign.support.EmptyObjectProvider;
import org.springframework.cloud.openfeign.support.FeignUtils;
import org.springframework.cloud.openfeign.support.HttpMessageConverterCustomizer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.client.HttpMessageConverterExtractor;

public class SpringDecoder
implements Decoder {
    private final ObjectProvider<HttpMessageConverter<?>> messageConverters;
    private final ObjectProvider<HttpMessageConverterCustomizer> customizers;

    public SpringDecoder(ObjectProvider<HttpMessageConverter<?>> messageConverters) {
        this(messageConverters, new EmptyObjectProvider<HttpMessageConverterCustomizer>());
    }

    public SpringDecoder(ObjectProvider<HttpMessageConverter<?>> messageConverters, ObjectProvider<HttpMessageConverterCustomizer> customizers) {
        this.messageConverters = messageConverters;
        this.customizers = customizers;
    }

    public Object decode(Response response, Type type) throws IOException, FeignException {
        if (type instanceof Class || type instanceof ParameterizedType || type instanceof WildcardType) {
            List converters = this.messageConverters.orderedStream().toList();
            this.customizers.forEach(customizer -> customizer.accept(converters));
            HttpMessageConverterExtractor extractor = new HttpMessageConverterExtractor(type, converters);
            return extractor.extractData((ClientHttpResponse)new FeignResponseAdapter(response));
        }
        throw new DecodeException(response.status(), "type is not an instance of Class or ParameterizedType: " + String.valueOf(type), response.request());
    }

    private final class FeignResponseAdapter
    implements ClientHttpResponse {
        private final Response response;

        private FeignResponseAdapter(Response response) {
            this.response = response;
        }

        public HttpStatusCode getStatusCode() {
            return HttpStatusCode.valueOf((int)this.response.status());
        }

        public String getStatusText() {
            return this.response.reason();
        }

        public void close() {
            try {
                this.response.body().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public InputStream getBody() throws IOException {
            return this.response.body() != null ? this.response.body().asInputStream() : null;
        }

        public HttpHeaders getHeaders() {
            return FeignUtils.getHttpHeaders(this.response.headers());
        }
    }
}

