/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.support;

import java.util.ArrayList;
import org.springframework.data.domain.Sort;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.TreeNode;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.node.ArrayNode;

public class SortJsonComponent {

    public static class SortDeserializer
    extends ValueDeserializer<Sort> {
        public Sort deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            TreeNode treeNode = jsonParser.readValueAsTree();
            if (treeNode.isArray()) {
                ArrayNode arrayNode = (ArrayNode)treeNode;
                return SortDeserializer.toSort(arrayNode);
            }
            if (treeNode.get("orders") != null && treeNode.get("orders").isArray()) {
                ArrayNode arrayNode = (ArrayNode)treeNode.get("orders");
                return SortDeserializer.toSort(arrayNode);
            }
            return null;
        }

        public Class<Sort> handledType() {
            return Sort.class;
        }

        private static Sort toSort(ArrayNode arrayNode) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (JsonNode jsonNode : arrayNode) {
                Sort.Order order;
                if (jsonNode.has("ignoreCase") && jsonNode.get("ignoreCase").isBoolean() && jsonNode.has("nullHandling") && jsonNode.get("nullHandling").isString()) {
                    boolean ignoreCase = jsonNode.get("ignoreCase").asBoolean();
                    String nullHandlingValue = jsonNode.get("nullHandling").asString();
                    order = new Sort.Order(Sort.Direction.valueOf((String)jsonNode.get("direction").asString()), jsonNode.get("property").asString(), ignoreCase, Sort.NullHandling.valueOf((String)nullHandlingValue));
                } else {
                    order = new Sort.Order(Sort.Direction.valueOf((String)jsonNode.get("direction").asString()), jsonNode.get("property").asString());
                }
                orders.add(order);
            }
            return Sort.by(orders);
        }
    }

    public static class SortSerializer
    extends ValueSerializer<Sort> {
        public void serialize(Sort value, JsonGenerator gen, SerializationContext serializers) {
            gen.writeStartArray();
            value.iterator().forEachRemaining(arg_0 -> ((JsonGenerator)gen).writePOJO(arg_0));
            gen.writeEndArray();
        }

        public Class<Sort> handledType() {
            return Sort.class;
        }
    }
}

