/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.hateoas;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.openfeign.hateoas.WebConvertersCustomizer;
import org.springframework.cloud.openfeign.support.HttpMessageConverterCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.config.WebConverters;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication
@ConditionalOnClass(value={WebConverters.class})
@AutoConfigureAfter(name={"org.springframework.boot.data.rest.autoconfigure.RepositoryRestMvcAutoConfiguration", "org.springframework.boot.http.converter.autoconfigure.HttpMessageConvertersAutoConfiguration", "org.springframework.boot.jackson.autoconfigure.JacksonAutoConfiguration"})
public class FeignHalAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={WebConverters.class})
    HttpMessageConverterCustomizer webConvertersCustomizer(WebConverters webConverters) {
        return new WebConvertersCustomizer(webConverters);
    }
}

