/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.aot;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.aot.BeanRegistrationExcludeFilter;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.cloud.openfeign.FeignClientFactory;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.cloud.openfeign.FeignClientSpecification;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.javapoet.MethodSpec;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class FeignClientBeanFactoryInitializationAotProcessor
implements BeanRegistrationExcludeFilter,
BeanFactoryInitializationAotProcessor {
    private final GenericApplicationContext context;
    private final Map<String, BeanDefinition> feignClientBeanDefinitions;
    private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

    public FeignClientBeanFactoryInitializationAotProcessor(GenericApplicationContext context, FeignClientFactory feignClientFactory) {
        this.context = context;
        this.feignClientBeanDefinitions = this.getFeignClientBeanDefinitions(feignClientFactory);
    }

    public boolean isExcludedFromAotProcessing(RegisteredBean registeredBean) {
        return registeredBean.getBeanClass().equals(FeignClientFactoryBean.class) || this.feignClientBeanDefinitions.containsKey(registeredBean.getBeanClass().getName());
    }

    private Map<String, BeanDefinition> getFeignClientBeanDefinitions(FeignClientFactory feignClientFactory) {
        Map configurations = feignClientFactory.getConfigurations();
        return configurations.values().stream().map(FeignClientSpecification::getClassName).filter(Objects::nonNull).filter(className -> !className.equals("default")).map(className -> Map.entry(className, this.context.getBeanDefinition(className))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        ConfigurableListableBeanFactory applicationBeanFactory = this.context.getBeanFactory();
        if (this.feignClientBeanDefinitions.isEmpty() || !beanFactory.equals((Object)applicationBeanFactory)) {
            return null;
        }
        return new AotContribution(this.feignClientBeanDefinitions);
    }

    private void registerMethodHints(ReflectionHints hints, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            this.registerMethodHints(hints, method);
        }
        this.introspectPublicMethodsOnAllInterfaces(hints, clazz);
    }

    private void introspectPublicMethodsOnAllInterfaces(ReflectionHints hints, Class<?> clazz) {
        for (Class<?> currentClass = clazz; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Class<?> interfaceType : currentClass.getInterfaces()) {
                if (ClassUtils.isJavaLanguageInterface(interfaceType)) continue;
                hints.registerType(interfaceType, new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS});
                this.introspectPublicMethodsOnAllInterfaces(hints, interfaceType);
            }
        }
    }

    private void registerMethodHints(ReflectionHints hints, Method method) {
        for (Parameter parameter : method.getParameters()) {
            this.bindingRegistrar.registerReflectionHints(hints, new Type[]{MethodParameter.forParameter((Parameter)parameter).getGenericParameterType()});
        }
        MethodParameter returnTypeParameter = MethodParameter.forExecutable((Executable)method, (int)-1);
        if (!Void.TYPE.equals(returnTypeParameter.getParameterType())) {
            this.bindingRegistrar.registerReflectionHints(hints, new Type[]{returnTypeParameter.getGenericParameterType()});
        }
    }

    final class AotContribution
    implements BeanFactoryInitializationAotContribution {
        private final Map<String, BeanDefinition> feignClientBeanDefinitions;

        private AotContribution(Map<String, BeanDefinition> feignClientBeanDefinitions) {
            this.feignClientBeanDefinitions = feignClientBeanDefinitions;
        }

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            RuntimeHints hints = generationContext.getRuntimeHints();
            Set feignClientRegistrationMethods = this.feignClientBeanDefinitions.values().stream().map(beanDefinition -> {
                Assert.notNull((Object)beanDefinition, (String)"beanDefinition cannot be null");
                Assert.isInstanceOf(GenericBeanDefinition.class, (Object)beanDefinition);
                GenericBeanDefinition registeredBeanDefinition = (GenericBeanDefinition)beanDefinition;
                MutablePropertyValues feignClientProperties = registeredBeanDefinition.getPropertyValues();
                String className = (String)feignClientProperties.get("type");
                Assert.notNull((Object)className, (String)"className cannot be null");
                Class clazz = ClassUtils.resolveClassName((String)className, null);
                hints.proxies().registerJdkProxy(new Class[]{clazz});
                FeignClientBeanFactoryInitializationAotProcessor.this.registerMethodHints(hints.reflection(), clazz);
                return beanFactoryInitializationCode.getMethods().add(this.buildMethodName(className), method -> this.generateFeignClientRegistrationMethod((MethodSpec.Builder)method, feignClientProperties, registeredBeanDefinition)).getName();
            }).collect(Collectors.toSet());
            MethodReference initializerMethod = beanFactoryInitializationCode.getMethods().add("initialize", method -> this.generateInitializerMethod((MethodSpec.Builder)method, feignClientRegistrationMethods)).toMethodReference();
            beanFactoryInitializationCode.addInitializer(initializerMethod);
        }

        private String buildMethodName(String clientName) {
            return "register" + clientName + "FeignClient";
        }

        private void generateInitializerMethod(MethodSpec.Builder method, Set<String> feignClientRegistrationMethods) {
            method.addModifiers(new Modifier[]{Modifier.PUBLIC});
            method.addParameter(DefaultListableBeanFactory.class, "registry", new Modifier[0]);
            feignClientRegistrationMethods.forEach(feignClientRegistrationMethod -> method.addStatement("$N(registry)", new Object[]{feignClientRegistrationMethod}));
        }

        private void generateFeignClientRegistrationMethod(MethodSpec.Builder method, MutablePropertyValues feignClientPropertyValues, GenericBeanDefinition registeredBeanDefinition) {
            Object feignQualifiers = feignClientPropertyValues.get("qualifiers");
            Assert.notNull((Object)feignQualifiers, (String)"Feign qualifiers cannot be null");
            String qualifiers = "{\"" + String.join((CharSequence)"\",\"", (String[])feignQualifiers) + "\"}";
            method.addJavadoc("register Feign Client: $L", new Object[]{feignClientPropertyValues.get("type")}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(BeanDefinitionRegistry.class, "registry", new Modifier[0]).addStatement("Class clazz = $T.resolveClassName(\"$L\", null)", new Object[]{ClassUtils.class, feignClientPropertyValues.get("type")}).addStatement("$T definition = $T.genericBeanDefinition($T.class)", new Object[]{BeanDefinitionBuilder.class, BeanDefinitionBuilder.class, FeignClientFactoryBean.class}).addStatement("definition.addPropertyValue(\"name\",\"$L\")", new Object[]{feignClientPropertyValues.get("name")}).addStatement("definition.addPropertyValue(\"contextId\", \"$L\")", new Object[]{feignClientPropertyValues.get("contextId")}).addStatement("definition.addPropertyValue(\"type\", clazz)", new Object[0]).addStatement("definition.addPropertyValue(\"url\", \"$L\")", new Object[]{feignClientPropertyValues.get("url")}).addStatement("definition.addPropertyValue(\"path\", \"$L\")", new Object[]{feignClientPropertyValues.get("path")}).addStatement("definition.addPropertyValue(\"dismiss404\", $L)", new Object[]{feignClientPropertyValues.get("dismiss404")}).addStatement("definition.addPropertyValue(\"fallback\", $T.class)", new Object[]{feignClientPropertyValues.get("fallback")}).addStatement("definition.addPropertyValue(\"fallbackFactory\", $T.class)", new Object[]{feignClientPropertyValues.get("fallbackFactory")}).addStatement("definition.setAutowireMode($L)", new Object[]{registeredBeanDefinition.getAutowireMode()}).addStatement("definition.setLazyInit($L)", new Object[]{registeredBeanDefinition.getLazyInit() != null ? registeredBeanDefinition.getLazyInit() : false}).addStatement("$T beanDefinition = definition.getBeanDefinition()", new Object[]{AbstractBeanDefinition.class}).addStatement("beanDefinition.setAttribute(\"$L\", clazz)", new Object[]{"factoryBeanObjectType"}).addStatement("beanDefinition.setPrimary($L)", new Object[]{registeredBeanDefinition.isPrimary()}).addStatement("$T holder = new $T(beanDefinition, \"$L\",  new String[]$L)", new Object[]{BeanDefinitionHolder.class, BeanDefinitionHolder.class, feignClientPropertyValues.get("type"), qualifiers}).addStatement("$T.registerBeanDefinition(holder, registry) ", new Object[]{BeanDefinitionReaderUtils.class});
        }

        Map<String, BeanDefinition> getFeignClientBeanDefinitions() {
            return this.feignClientBeanDefinitions;
        }
    }
}

