/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import feign.Capability;
import feign.Client;
import feign.Feign;
import feign.Target;
import feign.hc5.ApacheHttp5Client;
import feign.http2client.Http2Client;
import java.lang.reflect.Method;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.interceptor.CacheInterceptor;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.openfeign.CachingCapability;
import org.springframework.cloud.openfeign.CircuitBreakerNameResolver;
import org.springframework.cloud.openfeign.DefaultTargeter;
import org.springframework.cloud.openfeign.FeignCircuitBreakerDisabledConditions;
import org.springframework.cloud.openfeign.FeignCircuitBreakerTargeter;
import org.springframework.cloud.openfeign.FeignClientFactory;
import org.springframework.cloud.openfeign.FeignClientProperties;
import org.springframework.cloud.openfeign.FeignClientSpecification;
import org.springframework.cloud.openfeign.Targeter;
import org.springframework.cloud.openfeign.aot.FeignChildContextInitializer;
import org.springframework.cloud.openfeign.aot.FeignClientBeanFactoryInitializationAotProcessor;
import org.springframework.cloud.openfeign.security.OAuth2AccessTokenInterceptor;
import org.springframework.cloud.openfeign.support.FeignEncoderProperties;
import org.springframework.cloud.openfeign.support.FeignHttpClientProperties;
import org.springframework.cloud.openfeign.support.PageJacksonModule;
import org.springframework.cloud.openfeign.support.SortJacksonModule;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Feign.class})
@EnableConfigurationProperties(value={FeignClientProperties.class, FeignHttpClientProperties.class, FeignEncoderProperties.class})
public class FeignAutoConfiguration {
    private static final Log LOG = LogFactory.getLog(FeignAutoConfiguration.class);
    @Autowired(required=false)
    private List<FeignClientSpecification> configurations = new ArrayList<FeignClientSpecification>();

    @Bean
    public HasFeatures feignFeature() {
        return HasFeatures.namedFeature((String)"Feign", Feign.class);
    }

    @Bean
    public FeignClientFactory feignContext() {
        FeignClientFactory context = new FeignClientFactory();
        context.setConfigurations(this.configurations);
        return context;
    }

    @Bean
    static FeignChildContextInitializer feignChildContextInitializer(GenericApplicationContext parentContext, FeignClientFactory feignClientFactory) {
        return new FeignChildContextInitializer((ApplicationContext)parentContext, feignClientFactory);
    }

    @Bean
    static FeignClientBeanFactoryInitializationAotProcessor feignClientBeanFactoryInitializationCodeGenerator(GenericApplicationContext applicationContext, FeignClientFactory feignClientFactory) {
        return new FeignClientBeanFactoryInitializationAotProcessor(applicationContext, feignClientFactory);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.openfeign.cache.enabled"}, matchIfMissing=true)
    @ConditionalOnBean(value={CacheInterceptor.class})
    public Capability cachingCapability(CacheInterceptor cacheInterceptor) {
        return new CachingCapability(cacheInterceptor);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Http2Client.class, HttpClient.class})
    @ConditionalOnMissingBean(value={HttpClient.class})
    @ConditionalOnProperty(value={"spring.cloud.openfeign.http2client.enabled"})
    @Import(value={org.springframework.cloud.openfeign.clientconfig.Http2ClientFeignConfiguration.class})
    protected static class Http2ClientFeignConfiguration {
        protected Http2ClientFeignConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Client.class})
        public Client feignClient(HttpClient httpClient) {
            return new Http2Client(httpClient);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={OAuth2AuthorizedClientManager.class})
    @ConditionalOnProperty(value={"spring.cloud.openfeign.oauth2.enabled"})
    protected static class Oauth2FeignConfiguration {
        protected Oauth2FeignConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={OAuth2AuthorizedClientService.class, ClientRegistrationRepository.class})
        @ConditionalOnMissingBean
        OAuth2AuthorizedClientManager feignOAuth2AuthorizedClientManager(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService oAuth2AuthorizedClientService) {
            return new AuthorizedClientServiceOAuth2AuthorizedClientManager(clientRegistrationRepository, oAuth2AuthorizedClientService);
        }

        @Bean
        @ConditionalOnBean(value={OAuth2AuthorizedClientManager.class})
        public OAuth2AccessTokenInterceptor defaultOAuth2AccessTokenInterceptor(@Value(value="${spring.cloud.openfeign.oauth2.clientRegistrationId:}") String clientRegistrationId, OAuth2AuthorizedClientManager oAuth2AuthorizedClientManager) {
            return new OAuth2AccessTokenInterceptor(clientRegistrationId, oAuth2AuthorizedClientManager);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ApacheHttp5Client.class})
    @ConditionalOnMissingBean(value={CloseableHttpClient.class})
    @ConditionalOnProperty(value={"spring.cloud.openfeign.httpclient.hc5.enabled"}, havingValue="true", matchIfMissing=true)
    @Import(value={org.springframework.cloud.openfeign.clientconfig.HttpClient5FeignConfiguration.class})
    protected static class HttpClient5FeignConfiguration {
        protected HttpClient5FeignConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Client.class})
        public Client feignClient(CloseableHttpClient httpClient5) {
            return new ApacheHttp5Client((org.apache.hc.client5.http.classic.HttpClient)httpClient5);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CircuitBreaker.class})
    @ConditionalOnProperty(value={"spring.cloud.openfeign.circuitbreaker.enabled"}, havingValue="true")
    protected static class CircuitBreakerPresentFeignTargeterConfiguration {
        protected CircuitBreakerPresentFeignTargeterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={CircuitBreakerFactory.class})
        public Targeter defaultFeignTargeter() {
            return new DefaultTargeter();
        }

        @Bean
        @ConditionalOnMissingBean(value={CircuitBreakerNameResolver.class})
        @ConditionalOnProperty(value={"spring.cloud.openfeign.circuitbreaker.alphanumeric-ids.enabled"}, havingValue="false")
        public CircuitBreakerNameResolver circuitBreakerNameResolver() {
            return new DefaultCircuitBreakerNameResolver();
        }

        @Bean
        @ConditionalOnMissingBean(value={CircuitBreakerNameResolver.class})
        @ConditionalOnProperty(value={"spring.cloud.openfeign.circuitbreaker.alphanumeric-ids.enabled"}, havingValue="true", matchIfMissing=true)
        public CircuitBreakerNameResolver alphanumericCircuitBreakerNameResolver() {
            return new AlphanumericCircuitBreakerNameResolver();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={CircuitBreakerFactory.class})
        public Targeter circuitBreakerFeignTargeter(CircuitBreakerFactory circuitBreakerFactory, @Value(value="${spring.cloud.openfeign.circuitbreaker.group.enabled:false}") boolean circuitBreakerGroupEnabled, CircuitBreakerNameResolver circuitBreakerNameResolver) {
            return new FeignCircuitBreakerTargeter(circuitBreakerFactory, circuitBreakerGroupEnabled, circuitBreakerNameResolver);
        }

        static class DefaultCircuitBreakerNameResolver
        implements CircuitBreakerNameResolver {
            DefaultCircuitBreakerNameResolver() {
            }

            @Override
            public String resolveCircuitBreakerName(String feignClientName, Target<?> target, Method method) {
                return Feign.configKey((Class)target.type(), (Method)method);
            }
        }

        static class AlphanumericCircuitBreakerNameResolver
        extends DefaultCircuitBreakerNameResolver {
            AlphanumericCircuitBreakerNameResolver() {
            }

            @Override
            public String resolveCircuitBreakerName(String feignClientName, Target<?> target, Method method) {
                return super.resolveCircuitBreakerName(feignClientName, target, method).replaceAll("[^a-zA-Z0-9]", "");
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={FeignCircuitBreakerDisabledConditions.class})
    protected static class DefaultFeignTargeterConfiguration {
        protected DefaultFeignTargeterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Targeter feignTargeter() {
            return new DefaultTargeter();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Module.class, Page.class, Sort.class})
    @ConditionalOnProperty(value={"spring.cloud.openfeign.autoconfiguration.jackson.enabled"}, havingValue="true", matchIfMissing=true)
    protected static class FeignJacksonConfiguration {
        protected FeignJacksonConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={PageJacksonModule.class})
        public PageJacksonModule pageJacksonModule() {
            return new PageJacksonModule();
        }

        @Bean
        @ConditionalOnMissingBean(value={SortJacksonModule.class})
        public SortJacksonModule sortModule() {
            return new SortJacksonModule();
        }
    }
}

