/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.cloud.openfeign.FeignClientProperties;
import org.springframework.cloud.openfeign.FeignClientsRegistrar;
import org.springframework.cloud.openfeign.RefreshableUrl;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;

public class RefreshableUrlFactoryBean
implements FactoryBean<RefreshableUrl>,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private String contextId;
    private RefreshableUrl refreshableUrl;

    public Class<?> getObjectType() {
        return RefreshableUrl.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public RefreshableUrl getObject() {
        if (this.refreshableUrl != null) {
            return this.refreshableUrl;
        }
        FeignClientProperties properties = (FeignClientProperties)this.applicationContext.getBean(FeignClientProperties.class);
        if (Objects.isNull(properties.getConfig())) {
            return new RefreshableUrl(null);
        }
        FeignClientProperties.FeignClientConfiguration configuration = properties.getConfig().get(this.contextId);
        if (Objects.isNull(configuration) || !StringUtils.hasText((String)configuration.getUrl())) {
            return new RefreshableUrl(null);
        }
        this.refreshableUrl = new RefreshableUrl(FeignClientsRegistrar.getUrl(configuration.getUrl()));
        return this.refreshableUrl;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }
}

