/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.support;

import feign.Contract;
import feign.Feign;
import feign.MethodMetadata;
import feign.Param;
import feign.QueryMap;
import feign.Request;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.cloud.openfeign.CollectionFormat;
import org.springframework.cloud.openfeign.FeignClientProperties;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.cloud.openfeign.annotation.CookieValueParameterProcessor;
import org.springframework.cloud.openfeign.annotation.MatrixVariableParameterProcessor;
import org.springframework.cloud.openfeign.annotation.PathVariableParameterProcessor;
import org.springframework.cloud.openfeign.annotation.QueryMapParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestHeaderParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestParamParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestPartParameterProcessor;
import org.springframework.cloud.openfeign.support.FeignUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.domain.Pageable;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class SpringMvcContract
extends Contract.BaseContract
implements ResourceLoaderAware {
    private static final Log LOG = LogFactory.getLog(SpringMvcContract.class);
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final TypeDescriptor STRING_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
    private static final TypeDescriptor ITERABLE_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Iterable.class);
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private final Map<Class<? extends Annotation>, AnnotatedParameterProcessor> annotatedArgumentProcessors;
    private final Map<String, Method> processedMethods = new HashMap<String, Method>();
    private final ConversionService conversionService;
    private final ConvertingExpanderFactory convertingExpanderFactory;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final boolean decodeSlash;
    private final boolean removeTrailingSlash;

    public SpringMvcContract() {
        this(Collections.emptyList());
    }

    public SpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors) {
        this(annotatedParameterProcessors, (ConversionService)new DefaultConversionService());
    }

    public SpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors, ConversionService conversionService) {
        this(annotatedParameterProcessors, conversionService, true);
    }

    @Deprecated(forRemoval=true)
    public SpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors, ConversionService conversionService, boolean decodeSlash) {
        this(annotatedParameterProcessors, conversionService, decodeSlash, false);
    }

    @Deprecated(forRemoval=true)
    public SpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors, ConversionService conversionService, boolean decodeSlash, boolean removeTrailingSlash) {
        Assert.notNull(annotatedParameterProcessors, (String)"Parameter processors can not be null.");
        Assert.notNull((Object)conversionService, (String)"ConversionService can not be null.");
        List<AnnotatedParameterProcessor> processors = this.getDefaultAnnotatedArgumentsProcessors();
        processors.addAll(annotatedParameterProcessors);
        this.annotatedArgumentProcessors = this.toAnnotatedArgumentProcessorMap(processors);
        this.conversionService = conversionService;
        this.convertingExpanderFactory = new ConvertingExpanderFactory(conversionService);
        this.decodeSlash = decodeSlash;
        this.removeTrailingSlash = removeTrailingSlash;
    }

    public SpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors, ConversionService conversionService, FeignClientProperties feignClientProperties) {
        this(annotatedParameterProcessors, conversionService, feignClientProperties == null || feignClientProperties.isDecodeSlash(), feignClientProperties != null && feignClientProperties.isRemoveTrailingSlash());
    }

    private static TypeDescriptor createTypeDescriptor(Method method, int paramIndex) {
        Parameter parameter = method.getParameters()[paramIndex];
        MethodParameter methodParameter = MethodParameter.forParameter((Parameter)parameter);
        TypeDescriptor typeDescriptor = new TypeDescriptor(methodParameter);
        if (typeDescriptor.isAssignableTo(ITERABLE_TYPE_DESCRIPTOR)) {
            TypeDescriptor elementTypeDescriptor = SpringMvcContract.getElementTypeDescriptor(typeDescriptor);
            Util.checkState((elementTypeDescriptor != null ? 1 : 0) != 0, (String)"Could not resolve element type of Iterable type %s. Not declared?", (Object[])new Object[]{typeDescriptor});
            typeDescriptor = elementTypeDescriptor;
        }
        return typeDescriptor;
    }

    private static TypeDescriptor getElementTypeDescriptor(TypeDescriptor typeDescriptor) {
        TypeDescriptor elementTypeDescriptor = typeDescriptor.getElementTypeDescriptor();
        if (elementTypeDescriptor == null && Iterable.class.isAssignableFrom(typeDescriptor.getType())) {
            ResolvableType type = typeDescriptor.getResolvableType().as(Iterable.class).getGeneric(new int[]{0});
            if (type.resolve() == null) {
                return null;
            }
            return new TypeDescriptor(type, null, typeDescriptor.getAnnotations());
        }
        return elementTypeDescriptor;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected void processAnnotationOnClass(MethodMetadata data, Class<?> clz) {
        RequestMapping classAnnotation = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation(clz, RequestMapping.class);
        if (classAnnotation != null) {
            LOG.error((Object)("Cannot process class: " + clz.getName() + ". @RequestMapping annotation is not allowed on @FeignClient interfaces."));
            throw new IllegalArgumentException("@RequestMapping annotation not allowed on @FeignClient interfaces");
        }
        CollectionFormat collectionFormat = (CollectionFormat)AnnotatedElementUtils.findMergedAnnotation(clz, CollectionFormat.class);
        if (collectionFormat != null) {
            data.template().collectionFormat(collectionFormat.value());
        }
    }

    public MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method) {
        this.processedMethods.put(Feign.configKey(targetType, (Method)method), method);
        return super.parseAndValidateMetadata(targetType, method);
    }

    protected void processAnnotationOnMethod(MethodMetadata data, Annotation methodAnnotation, Method method) {
        Object pathValue;
        if (methodAnnotation instanceof CollectionFormat) {
            CollectionFormat collectionFormat = (CollectionFormat)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, CollectionFormat.class);
            data.template().collectionFormat(collectionFormat.value());
        }
        if (!(methodAnnotation instanceof RequestMapping) && !methodAnnotation.annotationType().isAnnotationPresent(RequestMapping.class)) {
            return;
        }
        RequestMapping methodMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        Object[] methods = methodMapping.method();
        if (methods.length == 0) {
            methods = new RequestMethod[]{RequestMethod.GET};
        }
        this.checkOne(method, methods, "method");
        data.template().method(Request.HttpMethod.valueOf((String)methods[0].name()));
        this.checkAtMostOne(method, methodMapping.value(), "value");
        if (methodMapping.value().length > 0 && (pathValue = Util.emptyToNull((String)methodMapping.value()[0])) != null) {
            if (!((String)(pathValue = this.resolve((String)pathValue))).startsWith("/") && !data.template().path().endsWith("/")) {
                pathValue = "/" + (String)pathValue;
            }
            if (this.removeTrailingSlash && ((String)pathValue).endsWith("/")) {
                pathValue = ((String)pathValue).substring(0, ((String)pathValue).length() - 1);
            }
            data.template().uri((String)pathValue, true);
            if (data.template().decodeSlash() != this.decodeSlash) {
                data.template().decodeSlash(this.decodeSlash);
            }
        }
        this.parseProduces(data, methodMapping);
        this.parseConsumes(data, methodMapping);
        this.parseHeaders(data, methodMapping);
        this.parseParams(data, methodMapping);
        data.indexToExpander(new LinkedHashMap());
    }

    private String resolve(String value) {
        if (StringUtils.hasText((String)value) && this.resourceLoader instanceof ConfigurableApplicationContext) {
            return ((ConfigurableApplicationContext)this.resourceLoader).getEnvironment().resolvePlaceholders(value);
        }
        return value;
    }

    private void checkAtMostOne(Method method, Object[] values, String fieldName) {
        Util.checkState((values != null && (values.length == 0 || values.length == 1) ? 1 : 0) != 0, (String)"Method %s can only contain at most 1 %s field. Found: %s", (Object[])new Object[]{method.getName(), fieldName, values == null ? null : Arrays.asList(values)});
    }

    private void checkOne(Method method, Object[] values, String fieldName) {
        Util.checkState((values != null && values.length == 1 ? 1 : 0) != 0, (String)"Method %s can only contain 1 %s field. Found: %s", (Object[])new Object[]{method.getName(), fieldName, values == null ? null : Arrays.asList(values)});
    }

    protected boolean processAnnotationsOnParameter(MethodMetadata data, Annotation[] annotations, int paramIndex) {
        Param.Expander expander;
        TypeDescriptor typeDescriptor;
        boolean isHttpAnnotation = false;
        try {
            if (Pageable.class.isAssignableFrom(data.method().getParameterTypes()[paramIndex]) && !this.queryMapParamPresent(data)) {
                data.queryMapIndex(Integer.valueOf(paramIndex));
                return false;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        SimpleAnnotatedParameterContext context = new SimpleAnnotatedParameterContext(data, paramIndex);
        Method method = this.processedMethods.get(data.configKey());
        for (Annotation parameterAnnotation : annotations) {
            AnnotatedParameterProcessor processor = this.annotatedArgumentProcessors.get(parameterAnnotation.annotationType());
            if (processor == null) continue;
            Annotation processParameterAnnotation = this.synthesizeWithMethodParameterNameAsFallbackValue(parameterAnnotation, method, paramIndex);
            isHttpAnnotation |= processor.processArgument(context, processParameterAnnotation, method);
        }
        if (!this.isMultipartFormData(data) && isHttpAnnotation && data.indexToExpander().get(paramIndex) == null && this.conversionService.canConvert(typeDescriptor = SpringMvcContract.createTypeDescriptor(method, paramIndex), STRING_TYPE_DESCRIPTOR) && (expander = this.convertingExpanderFactory.getExpander(typeDescriptor)) != null) {
            data.indexToExpander().put(paramIndex, expander);
        }
        return isHttpAnnotation;
    }

    private boolean queryMapParamPresent(MethodMetadata data) {
        Annotation[][] paramsAnnotations = data.method().getParameterAnnotations();
        for (int i = 0; i < paramsAnnotations.length; ++i) {
            Annotation[] paramAnnotations = paramsAnnotations[i];
            Class<?> parameterType = data.method().getParameterTypes()[i];
            if (!Arrays.stream(paramAnnotations).anyMatch(annotation -> Map.class.isAssignableFrom(parameterType) && annotation instanceof RequestParam || annotation instanceof SpringQueryMap || annotation instanceof QueryMap)) continue;
            return true;
        }
        return false;
    }

    private void parseProduces(MethodMetadata md, RequestMapping annotation) {
        String clientAccepts;
        String[] serverProduces = annotation.produces();
        String string = clientAccepts = serverProduces.length == 0 ? null : Util.emptyToNull((String)serverProduces[0]);
        if (clientAccepts != null) {
            md.template().header(ACCEPT, new String[]{clientAccepts});
        }
    }

    private void parseConsumes(MethodMetadata md, RequestMapping annotation) {
        String clientProduces;
        String[] serverConsumes = annotation.consumes();
        String string = clientProduces = serverConsumes.length == 0 ? null : Util.emptyToNull((String)serverConsumes[0]);
        if (clientProduces != null) {
            md.template().header(CONTENT_TYPE, new String[]{clientProduces});
        }
    }

    private void parseHeaders(MethodMetadata md, RequestMapping annotation) {
        if (annotation.headers() != null) {
            for (String header : annotation.headers()) {
                int index = header.indexOf(61);
                if (header.contains("!=") || index < 0) continue;
                md.template().header(this.resolve(header.substring(0, index)), new String[]{this.resolve(header.substring(index + 1).trim())});
            }
        }
    }

    private void parseParams(MethodMetadata data, RequestMapping methodMapping) {
        String[] params = methodMapping.params();
        if (params == null) {
            return;
        }
        for (String param : params) {
            NameValueResolver nameValueResolver = new NameValueResolver(param);
            if (!nameValueResolver.isNegated()) {
                data.template().query(this.resolve(nameValueResolver.getName()), new String[]{this.resolve(nameValueResolver.getValue())});
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Negated params are not supported by Feign and ignored during parameter processing: " + param));
        }
    }

    private Map<Class<? extends Annotation>, AnnotatedParameterProcessor> toAnnotatedArgumentProcessorMap(List<AnnotatedParameterProcessor> processors) {
        HashMap<Class<? extends Annotation>, AnnotatedParameterProcessor> result = new HashMap<Class<? extends Annotation>, AnnotatedParameterProcessor>();
        for (AnnotatedParameterProcessor processor : processors) {
            result.put(processor.getAnnotationType(), processor);
        }
        return result;
    }

    private List<AnnotatedParameterProcessor> getDefaultAnnotatedArgumentsProcessors() {
        ArrayList<AnnotatedParameterProcessor> annotatedArgumentResolvers = new ArrayList<AnnotatedParameterProcessor>();
        annotatedArgumentResolvers.add(new MatrixVariableParameterProcessor());
        annotatedArgumentResolvers.add(new PathVariableParameterProcessor());
        annotatedArgumentResolvers.add(new RequestParamParameterProcessor());
        annotatedArgumentResolvers.add(new RequestHeaderParameterProcessor());
        annotatedArgumentResolvers.add(new QueryMapParameterProcessor());
        annotatedArgumentResolvers.add(new RequestPartParameterProcessor());
        annotatedArgumentResolvers.add(new CookieValueParameterProcessor());
        return annotatedArgumentResolvers;
    }

    private Annotation synthesizeWithMethodParameterNameAsFallbackValue(Annotation parameterAnnotation, Method method, int parameterIndex) {
        String[] parameterNames;
        Type[] parameterTypes;
        Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)parameterAnnotation);
        Object defaultValue = AnnotationUtils.getDefaultValue((Annotation)parameterAnnotation);
        if (defaultValue instanceof String && defaultValue.equals(annotationAttributes.get("value")) && this.shouldAddParameterName(parameterIndex, parameterTypes = method.getGenericParameterTypes(), parameterNames = PARAMETER_NAME_DISCOVERER.getParameterNames(method))) {
            annotationAttributes.put("value", parameterNames[parameterIndex]);
        }
        return AnnotationUtils.synthesizeAnnotation((Map)annotationAttributes, parameterAnnotation.annotationType(), null);
    }

    private boolean shouldAddParameterName(int parameterIndex, Type[] parameterTypes, String[] parameterNames) {
        return parameterNames != null && parameterNames.length > parameterIndex && parameterTypes != null && parameterTypes.length > parameterIndex;
    }

    private boolean isMultipartFormData(MethodMetadata data) {
        Collection contentTypes = (Collection)data.template().headers().get(CONTENT_TYPE);
        if (contentTypes != null && !contentTypes.isEmpty()) {
            String type = (String)contentTypes.iterator().next();
            try {
                return Objects.equals(MediaType.valueOf((String)type), MediaType.MULTIPART_FORM_DATA);
            }
            catch (InvalidMediaTypeException ignored) {
                return false;
            }
        }
        return false;
    }

    private record ConvertingExpanderFactory(ConversionService conversionService) {
        Param.Expander getExpander(TypeDescriptor typeDescriptor) {
            return value -> {
                Object converted = this.conversionService.convert(value, typeDescriptor, STRING_TYPE_DESCRIPTOR);
                return (String)converted;
            };
        }
    }

    private class SimpleAnnotatedParameterContext
    implements AnnotatedParameterProcessor.AnnotatedParameterContext {
        private final MethodMetadata methodMetadata;
        private final int parameterIndex;

        SimpleAnnotatedParameterContext(MethodMetadata methodMetadata, int parameterIndex) {
            this.methodMetadata = methodMetadata;
            this.parameterIndex = parameterIndex;
        }

        @Override
        public MethodMetadata getMethodMetadata() {
            return this.methodMetadata;
        }

        @Override
        public int getParameterIndex() {
            return this.parameterIndex;
        }

        @Override
        public void setParameterName(String name) {
            SpringMvcContract.this.nameParam(this.methodMetadata, name, this.parameterIndex);
        }

        @Override
        public Collection<String> setTemplateParameter(String name, Collection<String> rest) {
            return FeignUtils.addTemplateParameter(rest, name);
        }
    }

    private static class NameValueResolver {
        private final String name;
        private final String value;
        private final boolean isNegated;

        NameValueResolver(String expression) {
            int separator = expression.indexOf(61);
            if (separator == -1) {
                this.isNegated = expression.startsWith("!");
                this.name = this.isNegated ? expression.substring(1) : expression;
                this.value = null;
            } else {
                this.isNegated = separator > 0 && expression.charAt(separator - 1) == '!';
                this.name = this.isNegated ? expression.substring(0, separator - 1) : expression.substring(0, separator);
                this.value = expression.substring(separator + 1);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isNegated() {
            return this.isNegated;
        }
    }
}

