/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import feign.Request;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.cloud.openfeign.FeignClientSpecification;
import org.springframework.cloud.openfeign.OptionsFactoryBean;
import org.springframework.cloud.openfeign.RefreshableUrl;
import org.springframework.cloud.openfeign.RefreshableUrlFactoryBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class FeignClientsRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private Environment environment;

    FeignClientsRegistrar() {
    }

    static void validateFallback(Class clazz) {
        Assert.isTrue((!clazz.isInterface() ? 1 : 0) != 0, (String)"Fallback class must implement the interface annotated by @FeignClient");
    }

    static void validateFallbackFactory(Class clazz) {
        Assert.isTrue((!clazz.isInterface() ? 1 : 0) != 0, (String)"Fallback factory must produce instances of fallback classes that implement the interface annotated by @FeignClient");
    }

    static String getName(String name) {
        if (!StringUtils.hasText((String)name)) {
            return "";
        }
        String host = null;
        try {
            Object url = !name.startsWith("http://") && !name.startsWith("https://") ? "http://" + name : name;
            host = new URI((String)url).getHost();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Assert.state((host != null ? 1 : 0) != 0, (String)("Service id not legal hostname (" + name + ")"));
        return name;
    }

    static String getUrl(String url) {
        if (!(!StringUtils.hasText((String)url) || ((String)url).startsWith("#{") && ((String)url).contains("}"))) {
            if (!((String)url).contains("://")) {
                url = "http://" + (String)url;
            }
            if (((String)url).endsWith("/")) {
                url = ((String)url).substring(0, ((String)url).length() - 1);
            }
            try {
                new URL((String)url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException((String)url + " is malformed", e);
            }
        }
        return url;
    }

    static String getPath(String path) {
        if (StringUtils.hasText((String)path)) {
            if (!((String)(path = ((String)path).trim())).startsWith("/")) {
                path = "/" + (String)path;
            }
            if (((String)path).endsWith("/")) {
                path = ((String)path).substring(0, ((String)path).length() - 1);
            }
        }
        return path;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        this.registerDefaultConfiguration(metadata, registry);
        this.registerFeignClients(metadata, registry);
    }

    private void registerDefaultConfiguration(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Map defaultAttrs = metadata.getAnnotationAttributes(EnableFeignClients.class.getName(), true);
        if (defaultAttrs != null && defaultAttrs.containsKey("defaultConfiguration")) {
            String name = metadata.hasEnclosingClass() ? "default." + metadata.getEnclosingClassName() : "default." + metadata.getClassName();
            this.registerClientConfiguration(registry, name, "default", defaultAttrs.get("defaultConfiguration"));
        }
    }

    public void registerFeignClients(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Class[] clients;
        LinkedHashSet<AnnotatedGenericBeanDefinition> candidateComponents = new LinkedHashSet<AnnotatedGenericBeanDefinition>();
        Map attrs = metadata.getAnnotationAttributes(EnableFeignClients.class.getName());
        Class[] classArray = clients = attrs == null ? null : (Class[])attrs.get("clients");
        if (clients == null || clients.length == 0) {
            ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
            scanner.setResourceLoader(this.resourceLoader);
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(FeignClient.class));
            Set<String> set = this.getBasePackages(metadata);
            for (String basePackage : set) {
                candidateComponents.addAll(scanner.findCandidateComponents(basePackage));
            }
        } else {
            for (Class clazz : clients) {
                candidateComponents.add(new AnnotatedGenericBeanDefinition(clazz));
            }
        }
        for (BeanDefinition beanDefinition : candidateComponents) {
            if (!(beanDefinition instanceof AnnotatedBeanDefinition)) continue;
            AnnotatedBeanDefinition beanDefinition2 = (AnnotatedBeanDefinition)beanDefinition;
            AnnotationMetadata annotationMetadata = beanDefinition2.getMetadata();
            Assert.isTrue((boolean)annotationMetadata.isInterface(), (String)"@FeignClient can only be specified on an interface");
            Map attributes = annotationMetadata.getAnnotationAttributes(FeignClient.class.getCanonicalName());
            String name = this.getClientName(attributes);
            String className = annotationMetadata.getClassName();
            this.registerClientConfiguration(registry, name, className, attributes.get("configuration"));
            this.registerFeignClient(registry, annotationMetadata, attributes);
        }
    }

    private void registerFeignClient(BeanDefinitionRegistry registry, AnnotationMetadata annotationMetadata, Map<String, Object> attributes) {
        String className = annotationMetadata.getClassName();
        if (String.valueOf(false).equals(this.environment.getProperty("spring.cloud.openfeign.lazy-attributes-resolution", String.valueOf(false)))) {
            this.eagerlyRegisterFeignClientBeanDefinition(className, attributes, registry);
        } else {
            this.lazilyRegisterFeignClientBeanDefinition(className, attributes, registry);
        }
    }

    private void eagerlyRegisterFeignClientBeanDefinition(String className, Map<String, Object> attributes, BeanDefinitionRegistry registry) {
        Object fallbackFactory;
        this.validate(attributes);
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(FeignClientFactoryBean.class);
        definition.addPropertyValue("url", (Object)this.getUrl(null, attributes));
        definition.addPropertyValue("path", (Object)this.getPath(null, attributes));
        String name = this.getName(attributes);
        definition.addPropertyValue("name", (Object)name);
        String contextId = this.getContextId(null, attributes);
        definition.addPropertyValue("contextId", (Object)contextId);
        definition.addPropertyValue("type", (Object)className);
        definition.addPropertyValue("dismiss404", (Object)Boolean.parseBoolean(String.valueOf(attributes.get("dismiss404"))));
        Object fallback = attributes.get("fallback");
        if (fallback != null) {
            definition.addPropertyValue("fallback", fallback instanceof Class ? fallback : ClassUtils.resolveClassName((String)fallback.toString(), null));
        }
        if ((fallbackFactory = attributes.get("fallbackFactory")) != null) {
            definition.addPropertyValue("fallbackFactory", fallbackFactory instanceof Class ? fallbackFactory : ClassUtils.resolveClassName((String)fallbackFactory.toString(), null));
        }
        definition.addPropertyValue("fallbackFactory", attributes.get("fallbackFactory"));
        definition.setAutowireMode(2);
        definition.addPropertyValue("refreshableClient", (Object)this.isClientRefreshEnabled());
        Object[] qualifiers = this.getQualifiers(attributes);
        if (ObjectUtils.isEmpty((Object[])qualifiers)) {
            qualifiers = new String[]{contextId + "FeignClient"};
        }
        definition.addPropertyValue("qualifiers", (Object)qualifiers);
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        Class type = ClassUtils.resolveClassName((String)className, null);
        beanDefinition.setAttribute("factoryBeanObjectType", (Object)type);
        boolean primary = (Boolean)attributes.get("primary");
        beanDefinition.setPrimary(primary);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, className, (String[])qualifiers);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
        this.registerRefreshableBeanDefinition(registry, contextId, Request.Options.class, OptionsFactoryBean.class);
        this.registerRefreshableBeanDefinition(registry, contextId, RefreshableUrl.class, RefreshableUrlFactoryBean.class);
    }

    private void lazilyRegisterFeignClientBeanDefinition(String className, Map<String, Object> attributes, BeanDefinitionRegistry registry) {
        ConfigurableBeanFactory beanFactory = registry instanceof ConfigurableBeanFactory ? (ConfigurableBeanFactory)registry : null;
        Class clazz = ClassUtils.resolveClassName((String)className, null);
        String contextId = this.getContextId(beanFactory, attributes);
        String name = this.getName(attributes);
        FeignClientFactoryBean factoryBean = new FeignClientFactoryBean();
        factoryBean.setBeanFactory((BeanFactory)beanFactory);
        factoryBean.setName(name);
        factoryBean.setContextId(contextId);
        factoryBean.setType(clazz);
        factoryBean.setRefreshableClient(this.isClientRefreshEnabled());
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition((Class)clazz, () -> {
            Object fallbackFactory;
            factoryBean.setUrl(this.getUrl(beanFactory, attributes));
            factoryBean.setPath(this.getPath(beanFactory, attributes));
            factoryBean.setDismiss404(Boolean.parseBoolean(String.valueOf(attributes.get("dismiss404"))));
            Object fallback = attributes.get("fallback");
            if (fallback != null) {
                factoryBean.setFallback(fallback instanceof Class ? (Class)fallback : ClassUtils.resolveClassName((String)fallback.toString(), null));
            }
            if ((fallbackFactory = attributes.get("fallbackFactory")) != null) {
                factoryBean.setFallbackFactory(fallbackFactory instanceof Class ? (Class)fallbackFactory : ClassUtils.resolveClassName((String)fallbackFactory.toString(), null));
            }
            return factoryBean.getObject();
        });
        definition.setAutowireMode(2);
        definition.setLazyInit(true);
        this.validate(attributes);
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        beanDefinition.setAttribute("feignClientsRegistrarFactoryBean", (Object)factoryBean);
        boolean primary = (Boolean)attributes.get("primary");
        beanDefinition.setPrimary(primary);
        Object[] qualifiers = this.getQualifiers(attributes);
        if (ObjectUtils.isEmpty((Object[])qualifiers)) {
            qualifiers = new String[]{contextId + "FeignClient"};
        }
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, className, (String[])qualifiers);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
        this.registerRefreshableBeanDefinition(registry, contextId, Request.Options.class, OptionsFactoryBean.class);
        this.registerRefreshableBeanDefinition(registry, contextId, RefreshableUrl.class, RefreshableUrlFactoryBean.class);
    }

    private void validate(Map<String, Object> attributes) {
        AnnotationAttributes annotation = AnnotationAttributes.fromMap(attributes);
        FeignClientsRegistrar.validateFallback(annotation.getClass("fallback"));
        FeignClientsRegistrar.validateFallbackFactory(annotation.getClass("fallbackFactory"));
    }

    String getName(Map<String, Object> attributes) {
        String name = (String)attributes.get("serviceId");
        if (!StringUtils.hasText((String)name)) {
            name = (String)attributes.get("name");
        }
        if (!StringUtils.hasText((String)name)) {
            name = (String)attributes.get("value");
        }
        name = this.resolve(null, name);
        return FeignClientsRegistrar.getName(name);
    }

    private String getContextId(ConfigurableBeanFactory beanFactory, Map<String, Object> attributes) {
        String contextId = (String)attributes.get("contextId");
        if (!StringUtils.hasText((String)contextId)) {
            return this.getName(attributes);
        }
        contextId = this.resolve(beanFactory, contextId);
        return FeignClientsRegistrar.getName(contextId);
    }

    private String resolve(ConfigurableBeanFactory beanFactory, String value) {
        if (StringUtils.hasText((String)value)) {
            if (beanFactory == null) {
                return this.environment.resolvePlaceholders(value);
            }
            BeanExpressionResolver resolver = beanFactory.getBeanExpressionResolver();
            String resolved = beanFactory.resolveEmbeddedValue(value);
            if (resolver == null) {
                return resolved;
            }
            Object evaluateValue = resolver.evaluate(resolved, new BeanExpressionContext(beanFactory, null));
            if (evaluateValue != null) {
                return String.valueOf(evaluateValue);
            }
            return null;
        }
        return value;
    }

    private String getUrl(ConfigurableBeanFactory beanFactory, Map<String, Object> attributes) {
        String url = this.resolve(beanFactory, (String)attributes.get("url"));
        return FeignClientsRegistrar.getUrl(url);
    }

    private String getPath(ConfigurableBeanFactory beanFactory, Map<String, Object> attributes) {
        String path = this.resolve(beanFactory, (String)attributes.get("path"));
        return FeignClientsRegistrar.getPath(path);
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                boolean isCandidate = false;
                if (beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation()) {
                    isCandidate = true;
                }
                return isCandidate;
            }
        };
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableFeignClients.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : (String[])attributes.get("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : (String[])attributes.get("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : (Class[])attributes.get("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }

    private String getQualifier(Map<String, Object> client) {
        if (client == null) {
            return null;
        }
        String qualifier = (String)client.get("qualifier");
        if (StringUtils.hasText((String)qualifier)) {
            return qualifier;
        }
        return null;
    }

    private String[] getQualifiers(Map<String, Object> client) {
        if (client == null) {
            return null;
        }
        List<String> qualifierList = new ArrayList<String>(Arrays.asList((String[])client.get("qualifiers")));
        qualifierList.removeIf(qualifier -> !StringUtils.hasText((String)qualifier));
        if (qualifierList.isEmpty() && this.getQualifier(client) != null) {
            qualifierList = Collections.singletonList(this.getQualifier(client));
        }
        return !qualifierList.isEmpty() ? qualifierList.toArray(new String[0]) : null;
    }

    private String getClientName(Map<String, Object> client) {
        if (client == null) {
            return null;
        }
        String value = (String)client.get("contextId");
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("value");
        }
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("name");
        }
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("serviceId");
        }
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        throw new IllegalStateException("Either 'name' or 'value' must be provided in @" + FeignClient.class.getSimpleName());
    }

    private void registerClientConfiguration(BeanDefinitionRegistry registry, Object name, Object className, Object configuration) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(FeignClientSpecification.class);
        builder.addConstructorArgValue(name);
        builder.addConstructorArgValue(className);
        builder.addConstructorArgValue(configuration);
        registry.registerBeanDefinition(name + "." + FeignClientSpecification.class.getSimpleName(), (BeanDefinition)builder.getBeanDefinition());
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private void registerRefreshableBeanDefinition(BeanDefinitionRegistry registry, String contextId, Class<?> beanType, Class<?> factoryBeanType) {
        if (this.isClientRefreshEnabled()) {
            String beanName = beanType.getCanonicalName() + "-" + contextId;
            BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(factoryBeanType);
            definitionBuilder.setScope("refresh");
            definitionBuilder.addPropertyValue("contextId", (Object)contextId);
            BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder((BeanDefinition)definitionBuilder.getBeanDefinition(), beanName);
            definitionHolder = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)registry, (boolean)true);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)registry);
        }
    }

    private boolean isClientRefreshEnabled() {
        return (Boolean)this.environment.getProperty("spring.cloud.openfeign.client.refresh-enabled", Boolean.class, (Object)false);
    }
}

