/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.annotation;

import feign.MethodMetadata;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.web.bind.annotation.MatrixVariable;

public class MatrixVariableParameterProcessor
implements AnnotatedParameterProcessor {
    private static final Class<MatrixVariable> ANNOTATION = MatrixVariable.class;

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return ANNOTATION;
    }

    @Override
    public boolean processArgument(AnnotatedParameterProcessor.AnnotatedParameterContext context, Annotation annotation, Method method) {
        int parameterIndex = context.getParameterIndex();
        Class<?> parameterType = method.getParameterTypes()[parameterIndex];
        MethodMetadata data = context.getMethodMetadata();
        String name = ANNOTATION.cast(annotation).value();
        Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"MatrixVariable annotation was empty on param %s.", (Object[])new Object[]{context.getParameterIndex()});
        context.setParameterName(name);
        if (Map.class.isAssignableFrom(parameterType)) {
            data.indexToExpander().put(parameterIndex, this::expandMap);
        } else {
            data.indexToExpander().put(parameterIndex, object -> ";" + name + "=" + object.toString());
        }
        return true;
    }

    private String expandMap(Object object) {
        Map paramMap = (Map)object;
        return paramMap.keySet().stream().filter(key -> paramMap.get(key) != null).map(key -> ";" + key + "=" + paramMap.get(key).toString()).collect(Collectors.joining());
    }
}

