/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.loadbalancer;

import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.DefaultRequest;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.InterceptorRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRecoveryCallback;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycleValidator;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.ResponseData;
import org.springframework.cloud.client.loadbalancer.RetryableRequestContext;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.loadbalancer.LoadBalancerResponseStatusCodeException;
import org.springframework.cloud.openfeign.loadbalancer.LoadBalancerUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class RetryableFeignBlockingLoadBalancerClient
implements Client {
    private static final Log LOG = LogFactory.getLog(RetryableFeignBlockingLoadBalancerClient.class);
    private final Client delegate;
    private final LoadBalancerClient loadBalancerClient;
    private final LoadBalancedRetryFactory loadBalancedRetryFactory;
    private final LoadBalancerClientFactory loadBalancerClientFactory;

    @Deprecated
    public RetryableFeignBlockingLoadBalancerClient(Client delegate, LoadBalancerClient loadBalancerClient, LoadBalancedRetryFactory loadBalancedRetryFactory, LoadBalancerProperties properties, LoadBalancerClientFactory loadBalancerClientFactory) {
        this.delegate = delegate;
        this.loadBalancerClient = loadBalancerClient;
        this.loadBalancedRetryFactory = loadBalancedRetryFactory;
        this.loadBalancerClientFactory = loadBalancerClientFactory;
    }

    public RetryableFeignBlockingLoadBalancerClient(Client delegate, LoadBalancerClient loadBalancerClient, LoadBalancedRetryFactory loadBalancedRetryFactory, LoadBalancerClientFactory loadBalancerClientFactory) {
        this.delegate = delegate;
        this.loadBalancerClient = loadBalancerClient;
        this.loadBalancedRetryFactory = loadBalancedRetryFactory;
        this.loadBalancerClientFactory = loadBalancerClientFactory;
    }

    public Response execute(feign.Request request, Request.Options options) throws IOException {
        URI originalUri = URI.create(request.url());
        String serviceId = originalUri.getHost();
        Assert.state((serviceId != null ? 1 : 0) != 0, (String)("Request URI does not contain a valid hostname: " + originalUri));
        LoadBalancedRetryPolicy retryPolicy = this.loadBalancedRetryFactory.createRetryPolicy(serviceId, (ServiceInstanceChooser)this.loadBalancerClient);
        RetryTemplate retryTemplate = this.buildRetryTemplate(serviceId, request, retryPolicy);
        return (Response)retryTemplate.execute(context -> {
            feign.Request feignRequest = null;
            ServiceInstance retrievedServiceInstance = null;
            Set supportedLifecycleProcessors = LoadBalancerLifecycleValidator.getSupportedLifecycleProcessors((Map)this.loadBalancerClientFactory.getInstances(serviceId, LoadBalancerLifecycle.class), RetryableRequestContext.class, ResponseData.class, ServiceInstance.class);
            String hint = this.getHint(serviceId);
            DefaultRequest lbRequest = new DefaultRequest((Object)new RetryableRequestContext(null, LoadBalancerUtils.buildRequestData(request), hint));
            if (context instanceof LoadBalancedRetryContext) {
                LoadBalancedRetryContext lbContext = (LoadBalancedRetryContext)context;
                ServiceInstance serviceInstance = lbContext.getServiceInstance();
                if (serviceInstance == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Service instance retrieved from LoadBalancedRetryContext: was null. Reattempting service instance selection");
                    }
                    ServiceInstance previousServiceInstance = lbContext.getPreviousServiceInstance();
                    ((RetryableRequestContext)lbRequest.getContext()).setPreviousServiceInstance(previousServiceInstance);
                    supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onStart((Request)lbRequest));
                    retrievedServiceInstance = this.loadBalancerClient.choose(serviceId, (Request)lbRequest);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("Selected service instance: %s", retrievedServiceInstance));
                    }
                    lbContext.setServiceInstance(retrievedServiceInstance);
                }
                if (retrievedServiceInstance == null) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)"Service instance was not resolved, executing the original request");
                    }
                    DefaultResponse lbResponse = new DefaultResponse(retrievedServiceInstance);
                    supportedLifecycleProcessors.forEach(arg_0 -> RetryableFeignBlockingLoadBalancerClient.lambda$null$1(lbRequest, (org.springframework.cloud.client.loadbalancer.Response)lbResponse, arg_0));
                    feignRequest = request;
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("Using service instance from LoadBalancedRetryContext: %s", retrievedServiceInstance));
                    }
                    String reconstructedUrl = this.loadBalancerClient.reconstructURI(retrievedServiceInstance, originalUri).toString();
                    feignRequest = this.buildRequest(request, reconstructedUrl);
                }
            }
            DefaultResponse lbResponse = new DefaultResponse(retrievedServiceInstance);
            LoadBalancerProperties loadBalancerProperties = this.loadBalancerClientFactory.getProperties(serviceId);
            Response response = LoadBalancerUtils.executeWithLoadBalancerLifecycleProcessing(this.delegate, options, feignRequest, (Request)lbRequest, (org.springframework.cloud.client.loadbalancer.Response<ServiceInstance>)lbResponse, supportedLifecycleProcessors, retrievedServiceInstance != null, loadBalancerProperties.isUseRawStatusCodeInResponseData());
            int responseStatus = response.status();
            if (retryPolicy != null && retryPolicy.retryableStatusCode(responseStatus)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Retrying on status code: %d", responseStatus));
                }
                byte[] byteArray = response.body() == null ? new byte[]{} : StreamUtils.copyToByteArray((InputStream)response.body().asInputStream());
                response.close();
                throw new LoadBalancerResponseStatusCodeException(serviceId, response, byteArray, URI.create(request.url()));
            }
            return response;
        }, (RecoveryCallback)new LoadBalancedRecoveryCallback<Response, Response>(){

            protected Response createResponse(Response response, URI uri) {
                return response;
            }
        });
    }

    protected feign.Request buildRequest(feign.Request request, String reconstructedUrl) {
        return feign.Request.create((Request.HttpMethod)request.httpMethod(), (String)reconstructedUrl, (Map)request.headers(), (byte[])request.body(), (Charset)request.charset(), (RequestTemplate)request.requestTemplate());
    }

    private RetryTemplate buildRetryTemplate(String serviceId, feign.Request request, LoadBalancedRetryPolicy retryPolicy) {
        RetryTemplate retryTemplate = new RetryTemplate();
        BackOffPolicy backOffPolicy = this.loadBalancedRetryFactory.createBackOffPolicy(serviceId);
        retryTemplate.setBackOffPolicy((BackOffPolicy)(backOffPolicy == null ? new NoBackOffPolicy() : backOffPolicy));
        RetryListener[] retryListeners = this.loadBalancedRetryFactory.createRetryListeners(serviceId);
        if (retryListeners != null && retryListeners.length != 0) {
            retryTemplate.setListeners(retryListeners);
        }
        retryTemplate.setRetryPolicy((RetryPolicy)(retryPolicy == null ? new NeverRetryPolicy() : new InterceptorRetryPolicy(this.toHttpRequest(request), retryPolicy, (ServiceInstanceChooser)this.loadBalancerClient, serviceId)));
        return retryTemplate;
    }

    public Client getDelegate() {
        return this.delegate;
    }

    private HttpRequest toHttpRequest(final feign.Request request) {
        return new HttpRequest(){

            public HttpMethod getMethod() {
                return HttpMethod.resolve((String)request.httpMethod().name());
            }

            public String getMethodValue() {
                return this.getMethod().name();
            }

            public URI getURI() {
                return URI.create(request.url());
            }

            public HttpHeaders getHeaders() {
                HashMap headers = new HashMap();
                Map feignHeaders = request.headers();
                for (String key : feignHeaders.keySet()) {
                    headers.put(key, new ArrayList((Collection)feignHeaders.get(key)));
                }
                HttpHeaders httpHeaders = new HttpHeaders();
                httpHeaders.putAll(headers);
                return httpHeaders;
            }
        };
    }

    private String getHint(String serviceId) {
        LoadBalancerProperties properties = this.loadBalancerClientFactory.getProperties(serviceId);
        String defaultHint = properties.getHint().getOrDefault("default", "default");
        String hintPropertyValue = (String)properties.getHint().get(serviceId);
        return hintPropertyValue != null ? hintPropertyValue : defaultHint;
    }

    private static /* synthetic */ void lambda$null$1(DefaultRequest lbRequest, org.springframework.cloud.client.loadbalancer.Response lbResponse, LoadBalancerLifecycle lifecycle) {
        lifecycle.onComplete(new CompletionContext(CompletionContext.Status.DISCARD, (Request)lbRequest, lbResponse));
    }
}

