/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine;

import com.netflix.turbine.discovery.InstanceDiscovery;
import com.netflix.turbine.init.TurbineInit;
import com.netflix.turbine.monitor.cluster.ClusterMonitorFactory;
import com.netflix.turbine.plugins.PluginsFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.Ordered;

public class TurbineLifecycle
implements SmartLifecycle,
Ordered {
    private final InstanceDiscovery instanceDiscovery;
    private final ClusterMonitorFactory<?> factory;
    private volatile boolean running;

    public TurbineLifecycle(InstanceDiscovery instanceDiscovery, ClusterMonitorFactory<?> factory) {
        this.instanceDiscovery = instanceDiscovery;
        this.factory = factory;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        callback.run();
    }

    public void start() {
        PluginsFactory.setClusterMonitorFactory(this.factory);
        PluginsFactory.setInstanceDiscovery((InstanceDiscovery)this.instanceDiscovery);
        TurbineInit.init();
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 0;
    }

    public int getOrder() {
        return -1;
    }
}

