/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import java.util.function.Function;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.netflix.hystrix.AbstractHystrixConfigBuilder;
import org.springframework.cloud.netflix.hystrix.HystrixCircuitBreaker;
import org.springframework.util.Assert;

public class HystrixCircuitBreakerFactory
extends CircuitBreakerFactory<HystrixCommand.Setter, HystrixConfigBuilder> {
    private Function<String, HystrixCommand.Setter> defaultConfiguration = id -> HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)((Object)((Object)this)).getClass().getSimpleName())).andCommandKey(HystrixCommandKey.Factory.asKey((String)id));

    public void configureDefault(Function<String, HystrixCommand.Setter> defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public HystrixConfigBuilder configBuilder(String id) {
        return new HystrixConfigBuilder(id);
    }

    public HystrixCircuitBreaker create(String id) {
        Assert.hasText((String)id, (String)"A CircuitBreaker must have an id.");
        HystrixCommand.Setter setter = this.getConfigurations().computeIfAbsent(id, this.defaultConfiguration);
        return new HystrixCircuitBreaker(setter);
    }

    public static class HystrixConfigBuilder
    extends AbstractHystrixConfigBuilder<HystrixCommand.Setter> {
        public HystrixConfigBuilder(String id) {
            super(id);
        }

        public HystrixCommand.Setter build() {
            return HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)this.getGroupKey()).andCommandKey(this.getCommandKey()).andCommandPropertiesDefaults(this.getCommandPropertiesSetter());
        }
    }
}

