/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route;

import com.netflix.client.ClientException;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.ribbon.support.RibbonRequestCustomizer;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandContext;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandFactory;
import org.springframework.cloud.netflix.zuul.util.ZuulRuntimeException;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MultiValueMap;

public class RibbonRoutingFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(RibbonRoutingFilter.class);
    protected ProxyRequestHelper helper;
    protected RibbonCommandFactory<?> ribbonCommandFactory;
    protected List<RibbonRequestCustomizer> requestCustomizers;
    private boolean useServlet31 = true;

    public RibbonRoutingFilter(ProxyRequestHelper helper, RibbonCommandFactory<?> ribbonCommandFactory, List<RibbonRequestCustomizer> requestCustomizers) {
        this.helper = helper;
        this.ribbonCommandFactory = ribbonCommandFactory;
        this.requestCustomizers = requestCustomizers;
        try {
            HttpServletResponse.class.getMethod("getContentLengthLong", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            this.useServlet31 = false;
        }
    }

    public RibbonRoutingFilter(RibbonCommandFactory<?> ribbonCommandFactory) {
        this(new ProxyRequestHelper(), ribbonCommandFactory, null);
    }

    public String filterType() {
        return "route";
    }

    public int filterOrder() {
        return 10;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        return ctx.getRouteHost() == null && ctx.get((Object)"serviceId") != null && ctx.sendZuulResponse();
    }

    public Object run() {
        RequestContext context = RequestContext.getCurrentContext();
        this.helper.addIgnoredHeaders(new String[0]);
        try {
            RibbonCommandContext commandContext = this.buildCommandContext(context);
            ClientHttpResponse response = this.forward(commandContext);
            this.setResponse(response);
            return response;
        }
        catch (ZuulException ex) {
            throw new ZuulRuntimeException(ex);
        }
        catch (Exception ex) {
            throw new ZuulRuntimeException(ex);
        }
    }

    protected RibbonCommandContext buildCommandContext(RequestContext context) {
        HttpServletRequest request = context.getRequest();
        MultiValueMap<String, String> headers = this.helper.buildZuulRequestHeaders(request);
        MultiValueMap<String, String> params = this.helper.buildZuulRequestQueryParams(request);
        String verb = this.getVerb(request);
        InputStream requestEntity = this.getRequestBody(request);
        if (request.getContentLength() < 0 && !verb.equalsIgnoreCase("GET")) {
            context.setChunkedRequestBody();
        }
        String serviceId = (String)context.get((Object)"serviceId");
        Boolean retryable = (Boolean)context.get((Object)"retryable");
        String uri = this.helper.buildZuulRequestURI(request);
        uri = uri.replace("//", "/");
        long contentLength = this.useServlet31 ? request.getContentLengthLong() : (long)request.getContentLength();
        return new RibbonCommandContext(serviceId, verb, uri, retryable, headers, params, requestEntity, this.requestCustomizers, contentLength);
    }

    protected ClientHttpResponse forward(RibbonCommandContext context) throws Exception {
        Map<String, Object> info = this.helper.debug(context.getMethod(), context.getUri(), context.getHeaders(), context.getParams(), context.getRequestEntity());
        Object command = this.ribbonCommandFactory.create(context);
        try {
            ClientHttpResponse response = (ClientHttpResponse)command.execute();
            this.helper.appendDebug(info, response.getStatusCode().value(), (MultiValueMap<String, String>)response.getHeaders());
            return response;
        }
        catch (HystrixRuntimeException ex) {
            return this.handleException(info, ex);
        }
    }

    protected ClientHttpResponse handleException(Map<String, Object> info, HystrixRuntimeException ex) throws ZuulException {
        int statusCode = HttpStatus.INTERNAL_SERVER_ERROR.value();
        Throwable cause = ex;
        String message = ex.getFailureType().toString();
        ClientException clientException = this.findClientException(ex);
        if (clientException == null) {
            clientException = this.findClientException(ex.getFallbackException());
        }
        if (clientException != null) {
            if (clientException.getErrorType() == ClientException.ErrorType.SERVER_THROTTLED) {
                statusCode = HttpStatus.SERVICE_UNAVAILABLE.value();
            }
            cause = clientException;
            message = clientException.getErrorType().toString();
        }
        info.put("status", String.valueOf(statusCode));
        throw new ZuulException(cause, "Forwarding error", statusCode, message);
    }

    protected ClientException findClientException(Throwable t) {
        if (t == null) {
            return null;
        }
        if (t instanceof ClientException) {
            return (ClientException)t;
        }
        return this.findClientException(t.getCause());
    }

    protected InputStream getRequestBody(HttpServletRequest request) {
        InputStream requestEntity = null;
        try {
            requestEntity = (InputStream)RequestContext.getCurrentContext().get((Object)"requestEntity");
            if (requestEntity == null) {
                requestEntity = request.getInputStream();
            }
        }
        catch (IOException ex) {
            log.error((Object)"Error during getRequestBody", (Throwable)ex);
        }
        return requestEntity;
    }

    protected String getVerb(HttpServletRequest request) {
        String method = request.getMethod();
        if (method == null) {
            return "GET";
        }
        return method;
    }

    protected void setResponse(ClientHttpResponse resp) throws ClientException, IOException {
        RequestContext.getCurrentContext().set("zuulResponse", (Object)resp);
        this.helper.setResponse(resp.getStatusCode().value(), resp.getBody() == null ? null : resp.getBody(), (MultiValueMap<String, String>)resp.getHeaders());
    }
}

