/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerContext;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;

public class RibbonLoadBalancedRetryPolicy
implements LoadBalancedRetryPolicy {
    public static final IClientConfigKey<String> RETRYABLE_STATUS_CODES = new CommonClientConfigKey<String>("retryableStatusCodes"){};
    private int sameServerCount = 0;
    private int nextServerCount = 0;
    private String serviceId;
    private RibbonLoadBalancerContext lbContext;
    private ServiceInstanceChooser loadBalanceChooser;
    List<Integer> retryableStatusCodes = new ArrayList<Integer>();

    public RibbonLoadBalancedRetryPolicy(String serviceId, RibbonLoadBalancerContext context, ServiceInstanceChooser loadBalanceChooser) {
        this.serviceId = serviceId;
        this.lbContext = context;
        this.loadBalanceChooser = loadBalanceChooser;
    }

    public RibbonLoadBalancedRetryPolicy(String serviceId, RibbonLoadBalancerContext context, ServiceInstanceChooser loadBalanceChooser, IClientConfig clientConfig) {
        String[] retryableStatusCodesArray;
        this.serviceId = serviceId;
        this.lbContext = context;
        this.loadBalanceChooser = loadBalanceChooser;
        String retryableStatusCodesProp = clientConfig.getPropertyAsString(RETRYABLE_STATUS_CODES, "");
        for (String code : retryableStatusCodesArray = retryableStatusCodesProp.split(",")) {
            if (StringUtils.isEmpty((Object)code)) continue;
            try {
                this.retryableStatusCodes.add(Integer.valueOf(code));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public boolean canRetry(LoadBalancedRetryContext context) {
        HttpMethod method = context.getRequest().getMethod();
        return HttpMethod.GET == method || this.lbContext.isOkToRetryOnAllOperations();
    }

    public boolean canRetrySameServer(LoadBalancedRetryContext context) {
        return this.sameServerCount < this.lbContext.getRetryHandler().getMaxRetriesOnSameServer() && this.canRetry(context);
    }

    public boolean canRetryNextServer(LoadBalancedRetryContext context) {
        return this.nextServerCount <= this.lbContext.getRetryHandler().getMaxRetriesOnNextServer() && this.canRetry(context);
    }

    public void close(LoadBalancedRetryContext context) {
    }

    public void registerThrowable(LoadBalancedRetryContext context, Throwable throwable) {
        if (!this.canRetrySameServer(context) && this.canRetryNextServer(context)) {
            context.setServiceInstance(this.loadBalanceChooser.choose(this.serviceId));
        }
        if (this.sameServerCount >= this.lbContext.getRetryHandler().getMaxRetriesOnSameServer() && this.canRetry(context)) {
            this.sameServerCount = 0;
            ++this.nextServerCount;
            if (!this.canRetryNextServer(context)) {
                context.setExhaustedOnly();
            }
        } else {
            ++this.sameServerCount;
        }
    }

    public boolean retryableStatusCode(int statusCode) {
        return this.retryableStatusCodes.contains(statusCode);
    }
}

