/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.metrics;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.cloud.netflix.metrics.RestTemplateUrlTemplateHolder;

@Aspect
public class RestTemplateUrlTemplateCapturingAspect {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* org.springframework.web.client.RestOperations+.*(String, ..))")
    Object captureUrlTemplate(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            String urlTemplate = (String)joinPoint.getArgs()[0];
            RestTemplateUrlTemplateHolder.setRestTemplateUrlTemplate(urlTemplate);
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            RestTemplateUrlTemplateHolder.clear();
        }
    }
}

