/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.endpoint;

import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.ServletWrappingController;

public abstract class ServletWrappingEndpoint
implements InitializingBean,
ApplicationContextAware,
ServletContextAware,
MvcEndpoint {
    private String path;
    private boolean sensitive;
    private boolean enabled = true;
    private final ServletWrappingController controller = new ServletWrappingController();

    public void afterPropertiesSet() throws Exception {
        this.controller.afterPropertiesSet();
    }

    public void setServletContext(ServletContext servletContext) {
        this.controller.setServletContext(servletContext);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.controller.setApplicationContext(applicationContext);
    }

    protected ServletWrappingEndpoint(Class<? extends Servlet> servletClass, String servletName, String path, boolean sensitive, boolean enabled) {
        this.controller.setServletClass(servletClass);
        this.controller.setServletName(servletName);
        this.path = path;
        this.sensitive = sensitive;
        this.enabled = enabled;
    }

    @RequestMapping(value={"**"})
    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.controller.handleRequest(request, response);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ServletWrappingController getController() {
        return this.controller;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public Class<? extends Endpoint<?>> getEndpointType() {
        return null;
    }
}

