/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.rx;

import org.springframework.cloud.netflix.rx.DeferredResultSubscriber;
import org.springframework.util.Assert;
import org.springframework.web.context.request.async.DeferredResult;
import rx.Single;

class SingleDeferredResult<T>
extends DeferredResult<T> {
    private static final Object EMPTY_RESULT = new Object();

    public SingleDeferredResult(Single<T> single) {
        this(null, EMPTY_RESULT, single);
    }

    public SingleDeferredResult(long timeout, Single<T> single) {
        this(timeout, EMPTY_RESULT, single);
    }

    public SingleDeferredResult(Long timeout, Object timeoutResult, Single<T> single) {
        super(timeout, timeoutResult);
        Assert.notNull(single, (String)"single can not be null");
        new DeferredResultSubscriber(single.toObservable(), this);
    }
}

